/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.Event;
import org.musicbrainz.mmd2.EventList;
import org.musicbrainz.mmd2.Metadata;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.EventIndexField;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.ResultsWriter;

public class EventWriter
extends ResultsWriter {
    public void write(Metadata metadata, Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        EventList areaList = of.createEventList();
        for (Result result : results.results) {
            result.setNormalizedScore(results.getMaxScore());
        }
        this.write(areaList.getEvent(), results);
        areaList.setCount(BigInteger.valueOf(results.getTotalHits()));
        areaList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setEventList(areaList);
    }

    public void write(List list, Results results) throws IOException {
        for (Result result : results.results) {
            this.write(list, result);
        }
    }

    public void write(List list, Result result) throws IOException {
        MbDocument doc = result.getDoc();
        Event event = (Event)MMDSerializer.unserialize((String)doc.get((IndexField)EventIndexField.EVENT_STORE), Event.class);
        event.setScore(String.valueOf(result.getNormalizedScore()));
        list.add(event);
    }

    public void adjustForJson(Metadata metadata) {
        if (metadata.getEventList().getEvent().size() > 0) {
            for (Event event : metadata.getEventList().getEvent()) {
                if (event.getAliasList() == null) continue;
                for (Alias alias : event.getAliasList().getAlias()) {
                    if (alias.getPrimary() == null) {
                        alias.setPrimary("false");
                        continue;
                    }
                    alias.setPrimary("true");
                }
            }
        }
    }
}

