/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.Metadata;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.mmd2.Place;
import org.musicbrainz.mmd2.PlaceList;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.index.PlaceIndexField;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.ResultsWriter;

public class PlaceWriter
extends ResultsWriter {
    public void write(Metadata metadata, Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        PlaceList areaList = of.createPlaceList();
        for (Result result : results.results) {
            result.setNormalizedScore(results.getMaxScore());
        }
        this.write(areaList.getPlace(), results);
        areaList.setCount(BigInteger.valueOf(results.getTotalHits()));
        areaList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setPlaceList(areaList);
    }

    public void write(List list, Results results) throws IOException {
        for (Result result : results.results) {
            this.write(list, result);
        }
    }

    public void write(List list, Result result) throws IOException {
        MbDocument doc = result.getDoc();
        Place place = (Place)MMDSerializer.unserialize((String)doc.get((IndexField)PlaceIndexField.PLACE_STORE), Place.class);
        place.setScore(String.valueOf(result.getNormalizedScore()));
        list.add(place);
    }

    public void adjustForJson(Metadata metadata) {
        if (metadata.getPlaceList().getPlace().size() > 0) {
            for (Place place : metadata.getPlaceList().getPlace()) {
                if (place.getAliasList() == null) continue;
                for (Alias alias : place.getAliasList().getAlias()) {
                    if (alias.getPrimary() == null) {
                        alias.setPrimary("false");
                        continue;
                    }
                    alias.setPrimary("true");
                }
            }
        }
    }
}

