/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.musicbrainz.mmd2.Alias;
import org.musicbrainz.mmd2.AreaList;
import org.musicbrainz.mmd2.DefAreaElementInner;
import org.musicbrainz.mmd2.Metadata;
import org.musicbrainz.mmd2.ObjectFactory;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.AreaIndexField;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd2.ResultsWriter;

public class AreaWriter
extends ResultsWriter {
    public void write(Metadata metadata, Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        AreaList areaList = of.createAreaList();
        for (Result result : results.results) {
            result.setNormalizedScore(results.getMaxScore());
        }
        this.write(areaList.getArea(), results);
        areaList.setCount(BigInteger.valueOf(results.getTotalHits()));
        areaList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setAreaList(areaList);
    }

    public void write(List list, Results results) throws IOException {
        for (Result result : results.results) {
            this.write(list, result);
        }
    }

    public void write(List list, Result result) throws IOException {
        MbDocument doc = result.getDoc();
        AreaList areaList = (AreaList)MMDSerializer.unserialize((String)doc.get((IndexField)AreaIndexField.AREA_STORE), AreaList.class);
        DefAreaElementInner area = (DefAreaElementInner)areaList.getArea().get(0);
        area.setScore(Integer.valueOf(result.getNormalizedScore()));
        list.add(area);
    }

    public void adjustForJson(Metadata metadata) {
        if (metadata.getAreaList().getArea().size() > 0) {
            for (DefAreaElementInner area : metadata.getAreaList().getArea()) {
                if (area.getAliasList() == null) continue;
                for (Alias alias : area.getAliasList().getAlias()) {
                    if (alias.getPrimary() == null) {
                        alias.setPrimary("false");
                        continue;
                    }
                    alias.setPrimary("true");
                }
            }
        }
    }
}

