/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.jms.EndpointMessageListener;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;

@ManagedResource(description="Managed JMS Consumer")
public class JmsConsumer
extends DefaultConsumer
implements Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(JmsConsumer.class);
    private volatile AbstractMessageListenerContainer listenerContainer;
    private volatile EndpointMessageListener messageListener;
    private volatile boolean initialized;
    private volatile ExecutorService executorService;
    private volatile boolean shutdownExecutorService;

    public JmsConsumer(JmsEndpoint endpoint, Processor processor, AbstractMessageListenerContainer listenerContainer) {
        super((Endpoint)endpoint, processor);
        this.listenerContainer = listenerContainer;
        this.listenerContainer.setMessageListener((Object)this.getEndpointMessageListener());
    }

    public JmsEndpoint getEndpoint() {
        return (JmsEndpoint)super.getEndpoint();
    }

    public AbstractMessageListenerContainer getListenerContainer() throws Exception {
        if (this.listenerContainer == null) {
            this.createMessageListenerContainer();
        }
        return this.listenerContainer;
    }

    public EndpointMessageListener getEndpointMessageListener() {
        if (this.messageListener == null) {
            this.createMessageListener(this.getEndpoint(), this.getProcessor());
        }
        return this.messageListener;
    }

    protected void createMessageListener(JmsEndpoint endpoint, Processor processor) {
        this.messageListener = new EndpointMessageListener(this, endpoint, processor);
        this.getEndpoint().getConfiguration().configureMessageListener(this.messageListener);
        this.messageListener.setBinding(endpoint.getBinding());
        this.messageListener.setAsync(endpoint.getConfiguration().isAsyncConsumer());
    }

    protected void createMessageListenerContainer() throws Exception {
        this.listenerContainer = this.getEndpoint().createMessageListenerContainer();
        this.getEndpoint().configureListenerContainer(this.listenerContainer, this);
        this.listenerContainer.setMessageListener((Object)this.getEndpointMessageListener());
    }

    void setListenerContainerExecutorService(ExecutorService executorService, boolean shutdownExecutorService) {
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
    }

    public void startListenerContainer() {
        LOG.trace("Starting listener container {} on destination {}", (Object)this.listenerContainer, (Object)this.getDestinationName());
        this.listenerContainer.start();
        LOG.debug("Started listener container {} on destination {}", (Object)this.listenerContainer, (Object)this.getDestinationName());
    }

    protected void testConnectionOnStartup() throws FailedToCreateConsumerException {
        try {
            LOG.debug("Testing JMS Connection on startup for destination: {}", (Object)this.getDestinationName());
            ConnectionFactory connectionfactory = this.listenerContainer.getConnectionFactory();
            if (connectionfactory == null) {
                LOG.error("connection factory is null");
                throw new IllegalStateException("connection factory is null");
            }
            Connection con = connectionfactory.createConnection();
            JmsUtils.closeConnection((Connection)con);
            LOG.debug("Successfully tested JMS Connection on startup for destination: {}", (Object)this.getDestinationName());
        }
        catch (Exception e) {
            String msg = "Cannot get JMS Connection on startup for destination " + this.getDestinationName();
            throw new FailedToCreateConsumerException((Endpoint)this.getEndpoint(), msg, (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.listenerContainer == null) {
            this.createMessageListenerContainer();
        }
        this.getEndpoint().onListenerContainerStarting();
        if (this.getEndpoint().getConfiguration().isAsyncStartListener()) {
            this.getEndpoint().getAsyncStartStopExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        JmsConsumer.this.prepareAndStartListenerContainer();
                    }
                    catch (Exception e) {
                        LOG.warn("Error starting listener container on destination: {}. This exception will be ignored.", (Object)JmsConsumer.this.getDestinationName(), (Object)e);
                    }
                }

                public String toString() {
                    return "AsyncStartListenerTask[" + JmsConsumer.this.getDestinationName() + "]";
                }
            });
        } else {
            this.prepareAndStartListenerContainer();
        }
        this.initialized = true;
    }

    protected void prepareAndStartListenerContainer() {
        this.listenerContainer.afterPropertiesSet();
        if (this.initialized || this.getEndpoint().isAutoStartup()) {
            if (this.getEndpoint().isTestConnectionOnStartup()) {
                this.testConnectionOnStartup();
            }
            this.startListenerContainer();
        }
    }

    protected void stopAndDestroyListenerContainer() {
        if (this.listenerContainer != null) {
            try {
                this.listenerContainer.stop();
                this.listenerContainer.destroy();
            }
            finally {
                this.getEndpoint().onListenerContainerStopped();
            }
        }
        this.listenerContainer = null;
        this.messageListener = null;
        this.initialized = false;
        if (this.shutdownExecutorService && this.executorService != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
        this.executorService = null;
    }

    protected void doStop() throws Exception {
        if (this.listenerContainer != null) {
            if (this.getEndpoint().getConfiguration().isAsyncStopListener()) {
                this.getEndpoint().getAsyncStartStopExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JmsConsumer.this.stopAndDestroyListenerContainer();
                        }
                        catch (Exception e) {
                            LOG.warn("Error stopping listener container on destination: {}. This exception will be ignored.", (Object)JmsConsumer.this.getDestinationName(), (Object)e);
                        }
                    }

                    public String toString() {
                        return "AsyncStopListenerTask[" + JmsConsumer.this.getDestinationName() + "]";
                    }
                });
            } else {
                this.stopAndDestroyListenerContainer();
            }
        }
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
        }
    }

    protected void doResume() throws Exception {
        if (!this.initialized) {
            this.doStart();
        } else if (this.listenerContainer != null) {
            this.startListenerContainer();
        } else {
            LOG.warn("The listenerContainer is not instantiated. Probably there was a timeout during the Suspend operation. Please restart your consumer route.");
        }
    }

    private String getDestinationName() {
        if (this.listenerContainer.getDestination() != null) {
            return this.listenerContainer.getDestination().toString();
        }
        return this.listenerContainer.getDestinationName();
    }

    @ManagedAttribute(description="Changes the JMS selector, as long the cache level is less than CACHE_CONSUMER.")
    public String getMessageSelector() {
        if (this.listenerContainer != null) {
            return this.listenerContainer.getMessageSelector();
        }
        return null;
    }

    @ManagedAttribute(description="Changes the JMS selector, as long the cache level is less than CACHE_CONSUMER.")
    public void setMessageSelector(String messageSelector) {
        if (this.listenerContainer != null) {
            this.listenerContainer.setMessageSelector(messageSelector);
        }
    }
}

