/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.bugs;

import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.beanutils2.bugs.other.Jira18BeanFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class Jira18Test {
    private static Object bean;

    @BeforeAll
    public static void beforeAll() {
        bean = Jira18BeanFactory.createBean();
    }

    @Test
    public void testIssue_BEANUTILS_18_PropertyUtils_getProperty() {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getProperty((Object)bean, (String)"simple"));
    }

    @Test
    public void testIssue_BEANUTILS_18_PropertyUtils_getProperty_Indexed() {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getProperty((Object)bean, (String)"indexed[0]"));
    }

    @Test
    public void testIssue_BEANUTILS_18_PropertyUtils_getProperty_Mapped() {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getProperty((Object)bean, (String)"mapped(foo-key)"));
    }

    @Test
    public void testIssue_BEANUTILS_18_PropertyUtils_isReadable() {
        Assertions.assertFalse((boolean)PropertyUtils.isReadable((Object)bean, (String)"simple"));
    }

    @Test
    public void testIssue_BEANUTILS_18_PropertyUtils_isReadable_Indexed() {
        Assertions.assertFalse((boolean)PropertyUtils.isReadable((Object)bean, (String)"indexed"));
    }

    @Test
    public void testIssue_BEANUTILS_18_PropertyUtils_isReadable_Mapped() {
        Assertions.assertFalse((boolean)PropertyUtils.isReadable((Object)bean, (String)"mapped"));
    }

    @Test
    public void testIssue_BEANUTILS_18_PropertyUtils_isWriteable() {
        Assertions.assertFalse((boolean)PropertyUtils.isWriteable((Object)bean, (String)"simple"));
    }

    @Test
    public void testIssue_BEANUTILS_18_PropertyUtils_isWriteable_Indexed() {
        Assertions.assertFalse((boolean)PropertyUtils.isWriteable((Object)bean, (String)"indexed"));
    }

    @Test
    public void testIssue_BEANUTILS_18_PropertyUtils_isWriteable_Mapped() {
        Assertions.assertFalse((boolean)PropertyUtils.isWriteable((Object)bean, (String)"mapped"));
    }

    @Test
    public void testIssue_BEANUTILS_18_PropertyUtils_setProperty() {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setProperty((Object)bean, (String)"simple", (Object)"BAR"));
    }

    @Test
    public void testIssue_BEANUTILS_18_PropertyUtils_setProperty_Indexed() {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setProperty((Object)bean, (String)"indexed[0]", (Object)"BAR"));
    }

    @Test
    public void testIssue_BEANUTILS_18_PropertyUtils_setProperty_Mapped() {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setProperty((Object)bean, (String)"mapped(foo-key)", (Object)"BAR"));
    }
}

