/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.EventListener;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class PooledConnectionProxy
implements PooledConnection,
ConnectionEventListener {
    protected PooledConnection delegate = null;
    private final Vector<EventListener> eventListeners = new Vector();
    private boolean notifyOnClose = false;

    public PooledConnectionProxy(PooledConnection pooledConnection) {
        this.delegate = pooledConnection;
        pooledConnection.addConnectionEventListener(this);
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
        if (this.isNotifyOnClose()) {
            this.notifyListeners();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public boolean isNotifyOnClose() {
        return this.notifyOnClose;
    }

    public void setNotifyOnClose(boolean notifyOnClose) {
        this.notifyOnClose = notifyOnClose;
    }

    void notifyListeners() {
        Object[] listeners;
        ConnectionEvent event = new ConnectionEvent(this);
        for (Object listener : listeners = this.eventListeners.toArray()) {
            ((ConnectionEventListener)listener).connectionClosed(event);
        }
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (!this.eventListeners.contains(listener)) {
            this.eventListeners.add(listener);
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        this.notifyListeners();
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        Object[] listeners;
        for (Object listener : listeners = this.eventListeners.toArray()) {
            ((ConnectionEventListener)listener).connectionErrorOccurred(event);
        }
    }

    public void throwConnectionError() {
        ConnectionEvent event = new ConnectionEvent(this);
        this.connectionErrorOccurred(event);
    }

    public Collection<EventListener> getListeners() {
        return this.eventListeners;
    }
}

