/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.DoubleValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DoubleValidatorTest
extends AbstractNumberValidatorTest {
    DoubleValidatorTest() {
    }

    @BeforeEach
    protected void setUp() {
        this.validator = new DoubleValidator(false, 0);
        this.strictValidator = new DoubleValidator();
        this.testPattern = "#,###.#";
        this.max = null;
        this.maxPlusOne = null;
        this.min = null;
        this.minMinusOne = null;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2"};
        this.invalid = new String[]{null, "", "X", "X12"};
        this.testNumber = 1234.5;
        this.testZero = 0.0;
        this.validStrict = new String[]{"0", "1234.5", "1,234.5"};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber};
        this.valid = new String[]{"0", "1234.5", "1,234.5", "1,234.5", "1234.5X"};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber};
        this.testStringUS = "1,234.5";
        this.localeValue = this.testStringDE = "1.234,5";
        this.localePattern = "#.###,#";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    @Test
    void testDoubleRangeMinMax() {
        DoubleValidator validator = (DoubleValidator)this.strictValidator;
        Double number9 = validator.validate("9", "#");
        Double number10 = validator.validate("10", "#");
        Double number11 = validator.validate("11", "#");
        Double number19 = validator.validate("19", "#");
        Double number20 = validator.validate("20", "#");
        Double number21 = validator.validate("21", "#");
        Assertions.assertFalse((boolean)validator.isInRange(number9, 10.0, 20.0), (String)"isInRange() < min");
        Assertions.assertTrue((boolean)validator.isInRange(number10, 10.0, 20.0), (String)"isInRange() = min");
        Assertions.assertTrue((boolean)validator.isInRange(number11, 10.0, 20.0), (String)"isInRange() in range");
        Assertions.assertTrue((boolean)validator.isInRange(number20, 10.0, 20.0), (String)"isInRange() = max");
        Assertions.assertFalse((boolean)validator.isInRange(number21, 10.0, 20.0), (String)"isInRange() > max");
        Assertions.assertFalse((boolean)validator.minValue(number9, 10.0), (String)"minValue() < min");
        Assertions.assertTrue((boolean)validator.minValue(number10, 10.0), (String)"minValue() = min");
        Assertions.assertTrue((boolean)validator.minValue(number11, 10.0), (String)"minValue() > min");
        Assertions.assertTrue((boolean)validator.maxValue(number19, 20.0), (String)"maxValue() < max");
        Assertions.assertTrue((boolean)validator.maxValue(number20, 20.0), (String)"maxValue() = max");
        Assertions.assertFalse((boolean)validator.maxValue(number21, 20.0), (String)"maxValue() > max");
    }

    @Test
    void testDoubleValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String germanPatternVal = "1.23.45";
        String localeVal = "12.345";
        String defaultVal = "12,345";
        String xxxx = "XXXX";
        Double expected = 12345.0;
        Assertions.assertEquals((Double)expected, (Double)DoubleValidator.getInstance().validate("12,345"), (String)"validate(A) default");
        Assertions.assertEquals((Double)expected, (Double)DoubleValidator.getInstance().validate("12.345", locale), (String)"validate(A) locale");
        Assertions.assertEquals((Double)expected, (Double)DoubleValidator.getInstance().validate("1,23,45", "0,00,00"), (String)"validate(A) pattern");
        Assertions.assertEquals((Double)expected, (Double)DoubleValidator.getInstance().validate("1.23.45", "0,00,00", Locale.GERMAN), (String)"validate(A) both");
        Assertions.assertTrue((boolean)DoubleValidator.getInstance().isValid("12,345"), (String)"isValid(A) default");
        Assertions.assertTrue((boolean)DoubleValidator.getInstance().isValid("12.345", locale), (String)"isValid(A) locale");
        Assertions.assertTrue((boolean)DoubleValidator.getInstance().isValid("1,23,45", "0,00,00"), (String)"isValid(A) pattern");
        Assertions.assertTrue((boolean)DoubleValidator.getInstance().isValid("1.23.45", "0,00,00", Locale.GERMAN), (String)"isValid(A) both");
        Assertions.assertNull((Object)DoubleValidator.getInstance().validate("XXXX"), (String)"validate(B) default");
        Assertions.assertNull((Object)DoubleValidator.getInstance().validate("XXXX", locale), (String)"validate(B) locale ");
        Assertions.assertNull((Object)DoubleValidator.getInstance().validate("XXXX", "0,00,00"), (String)"validate(B) pattern");
        Assertions.assertNull((Object)DoubleValidator.getInstance().validate("1,23,45", "0,00,00", Locale.GERMAN), (String)"validate(B) both");
        Assertions.assertFalse((boolean)DoubleValidator.getInstance().isValid("XXXX"), (String)"isValid(B) default");
        Assertions.assertFalse((boolean)DoubleValidator.getInstance().isValid("XXXX", locale), (String)"isValid(B) locale");
        Assertions.assertFalse((boolean)DoubleValidator.getInstance().isValid("XXXX", "0,00,00"), (String)"isValid(B) pattern");
        Assertions.assertFalse((boolean)DoubleValidator.getInstance().isValid("1,23,45", "0,00,00", Locale.GERMAN), (String)"isValid(B) both");
    }
}

