/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.rat.document.DocumentName;

public class ArchiveEntryName
extends DocumentName {
    private final DocumentName archiveFileName;

    private static DocumentName.Builder prepareBuilder(DocumentName archiveFileName, String archiveEntryName) {
        String root = archiveFileName.getName() + "#";
        DocumentName.FSInfo fsInfo = new DocumentName.FSInfo("archiveEntry", "/", true, Collections.singletonList(root));
        return DocumentName.builder(fsInfo).setRoot(root).setBaseName(root + "/").setName(archiveEntryName);
    }

    public ArchiveEntryName(DocumentName archiveFileName, String archiveEntryName) {
        super(ArchiveEntryName.prepareBuilder(archiveFileName, archiveEntryName));
        this.archiveFileName = archiveFileName;
    }

    @Override
    public File asFile() {
        return this.archiveFileName.asFile();
    }

    @Override
    public Path asPath() {
        return Paths.get(this.archiveFileName.asPath().toString(), "#", super.asPath().toString());
    }

    @Override
    public DocumentName resolve(String child) {
        return new ArchiveEntryName(this.archiveFileName, super.resolve(child).localized());
    }

    @Override
    public String getBaseName() {
        return this.archiveFileName.getName() + "#";
    }

    @Override
    boolean startsWithRootOrSeparator(String candidate, String root, String separator) {
        return super.startsWithRootOrSeparator(candidate, root, separator);
    }

    @Override
    public String localized(String dirSeparator) {
        String superLocal = super.localized(dirSeparator);
        superLocal = superLocal.substring(superLocal.lastIndexOf("#") + 1);
        return this.archiveFileName.localized(dirSeparator) + "#" + superLocal;
    }
}

