/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.rm.EncoderDecoder;
import org.apache.cxf.ws.rm.RM11Constants;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.v200702.AckRequestedType;
import org.apache.cxf.ws.rm.v200702.CloseSequenceType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceType;
import org.apache.cxf.ws.rm.v200702.DetailType;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.v200702.SequenceFaultType;
import org.apache.cxf.ws.rm.v200702.SequenceType;
import org.apache.cxf.ws.rm.v200702.TerminateSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.TerminateSequenceType;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class EncoderDecoder11Impl
extends EncoderDecoder {
    public static final EncoderDecoder11Impl INSTANCE = new EncoderDecoder11Impl();
    private static AtomicReference<JAXBContext> jaxbContextReference = new AtomicReference();
    private static final Logger LOG = LogUtils.getL7dLogger(EncoderDecoder11Impl.class);

    private EncoderDecoder11Impl() {
    }

    @Override
    public String getWSRMNamespace() {
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702";
    }

    @Override
    public String getWSANamespace() {
        return "http://www.w3.org/2005/08/addressing";
    }

    @Override
    public RMConstants getConstants() {
        return RM11Constants.INSTANCE;
    }

    @Override
    public Class<?> getCreateSequenceType() {
        return CreateSequenceType.class;
    }

    @Override
    public Class<?> getCreateSequenceResponseType() {
        return CreateSequenceResponseType.class;
    }

    @Override
    public Class<?> getTerminateSequenceType() {
        return TerminateSequenceType.class;
    }

    @Override
    public Class<?> getTerminateSequenceResponseType() {
        return TerminateSequenceResponseType.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected JAXBContext getContext() throws JAXBException {
        JAXBContext jaxbContext = jaxbContextReference.get();
        if (jaxbContext != null) return jaxbContext;
        Class<EncoderDecoder11Impl> clazz = EncoderDecoder11Impl.class;
        synchronized (EncoderDecoder11Impl.class) {
            jaxbContext = jaxbContextReference.get();
            if (jaxbContext != null) return jaxbContext;
            Class<?> clas = RMUtils.getWSRMFactory().getClass();
            jaxbContext = JAXBContext.newInstance((String)PackageUtils.getPackageName(clas), (ClassLoader)clas.getClassLoader());
            jaxbContextReference.set(jaxbContext);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return jaxbContext;
        }
    }

    @Override
    protected void buildHeaders(SequenceType seq, Collection<SequenceAcknowledgement> acks, Collection<AckRequestedType> reqs, boolean last, List<Header> headers) throws JAXBException {
        if (null != seq) {
            LOG.log(Level.FINE, "encoding sequence into RM header");
            JAXBElement<SequenceType> element = RMUtils.getWSRMFactory().createSequence(seq);
            headers.add((Header)new SoapHeader(element.getName(), element, this.getDataBinding(), true));
        }
        if (null != acks) {
            LOG.log(Level.FINE, "encoding sequence acknowledgement(s) into RM header");
            for (SequenceAcknowledgement ack : acks) {
                headers.add((Header)new SoapHeader(new QName(this.getConstants().getWSRMNamespace(), "SequenceAcknowledgement"), (Object)ack, this.getDataBinding()));
            }
        }
        if (null != reqs) {
            LOG.log(Level.FINE, "encoding acknowledgement request(s) into RM header");
            for (AckRequestedType req : reqs) {
                headers.add((Header)new SoapHeader(new QName(this.getConstants().getWSRMNamespace(), "AckRequested"), RMUtils.getWSRMFactory().createAckRequested(req), this.getDataBinding()));
            }
        }
    }

    @Override
    protected Object buildHeaderFaultObject(SequenceFault sf) {
        SequenceFaultType flt = new SequenceFaultType();
        flt.setFaultCode(sf.getFaultCode());
        Object detail = sf.getDetail();
        flt.getAny().add(detail);
        Element data = sf.getExtraDetail();
        if (data != null) {
            EncoderDecoder11Impl.addDetail(flt, data);
        }
        return flt;
    }

    private static void addDetail(SequenceFaultType sft, Element data) {
        if (!sft.isSetDetail()) {
            sft.setDetail(new DetailType());
        }
        sft.getDetail().getAny().add(data);
    }

    @Override
    public Element encodeSequenceAcknowledgement(SequenceAcknowledgement ack) throws JAXBException {
        DocumentFragment doc = DOMUtils.getEmptyDocument().createDocumentFragment();
        Marshaller marshaller = this.getContext().createMarshaller();
        marshaller.marshal((Object)ack, (Node)doc);
        return (Element)doc.getFirstChild();
    }

    @Override
    public Element encodeIdentifier(Identifier id) throws JAXBException {
        DocumentFragment doc = DOMUtils.getEmptyDocument().createDocumentFragment();
        Marshaller marshaller = this.getContext().createMarshaller();
        marshaller.marshal((Object)id, (Node)doc);
        return (Element)doc.getFirstChild();
    }

    @Override
    public SequenceType decodeSequenceType(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Node)elem, SequenceType.class);
        return (SequenceType)jaxbElement.getValue();
    }

    @Override
    public CloseSequenceType decodeSequenceTypeCloseSequence(Element elem) throws JAXBException {
        return null;
    }

    @Override
    public SequenceAcknowledgement decodeSequenceAcknowledgement(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        return (SequenceAcknowledgement)unmarshaller.unmarshal((Node)elem);
    }

    @Override
    public AckRequestedType decodeAckRequestedType(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Node)elem, AckRequestedType.class);
        return (AckRequestedType)jaxbElement.getValue();
    }

    @Override
    public Object convertToSend(CreateSequenceType create) {
        return create;
    }

    @Override
    public Object convertToSend(CreateSequenceResponseType create) {
        return create;
    }

    @Override
    public Object convertToSend(TerminateSequenceType term) {
        return term;
    }

    @Override
    public CreateSequenceType convertReceivedCreateSequence(Object create) {
        return (CreateSequenceType)create;
    }

    @Override
    public CreateSequenceResponseType convertReceivedCreateSequenceResponse(Object create) {
        return (CreateSequenceResponseType)create;
    }

    @Override
    public TerminateSequenceType convertReceivedTerminateSequence(Object term) {
        return (TerminateSequenceType)term;
    }
}

