/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.core.resourceadapter;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ConnectionEventListener;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionMetaData;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.core.logging.LoggerHelper;
import org.apache.cxf.jca.core.resourceadapter.AbstractManagedConnectionFactoryImpl;
import org.apache.cxf.jca.cxf.CXFManagedConnectionMetaData;

public abstract class AbstractManagedConnectionImpl
implements ManagedConnection {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractManagedConnectionImpl.class);
    protected PrintWriter printWriter;
    protected ConnectionRequestInfo crinfo;
    protected Subject subject;
    protected Set<ConnectionEventListener> connectionEventListeners = new HashSet<ConnectionEventListener>();
    private final AbstractManagedConnectionFactoryImpl managedConnectionFactory;

    public AbstractManagedConnectionImpl(AbstractManagedConnectionFactoryImpl managedFactory, ConnectionRequestInfo crInfo, Subject sj) throws ResourceException {
        this.managedConnectionFactory = managedFactory;
        this.crinfo = crInfo;
        this.subject = sj;
    }

    public void addConnectionEventListener(ConnectionEventListener aListener) {
        LOG.log(Level.FINE, "ADD_EVENT_LISTENER_CALLED", new Object[]{this, aListener});
        this.connectionEventListeners.add(aListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener aListener) {
        this.connectionEventListeners.remove(aListener);
    }

    public abstract void associateConnection(Object var1) throws ResourceException;

    public abstract Object getConnection(Subject var1, ConnectionRequestInfo var2) throws ResourceException;

    public abstract boolean isBound();

    public void close(Object closingHandle) throws ResourceException {
        LOG.fine("Closing handle: " + String.valueOf(closingHandle));
        ConnectionEvent coEvent = new ConnectionEvent((ManagedConnection)this, 1);
        coEvent.setConnectionHandle(closingHandle);
        this.sendEvent(coEvent);
    }

    public void cleanup() throws ResourceException {
        LOG.log(Level.FINE, "CLEANUP_CALLED", new Object[]{this});
    }

    public void destroy() throws ResourceException {
        LOG.log(Level.FINE, "DESTROY_CALLED", new Object[]{this});
        this.connectionEventListeners = new HashSet<ConnectionEventListener>();
        LoggerHelper.deleteLoggingOnWriter();
        if (this.printWriter != null) {
            this.printWriter.close();
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.printWriter;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new CXFManagedConnectionMetaData();
    }

    public void setLogWriter(PrintWriter aPrintWriter) throws ResourceException {
        this.printWriter = aPrintWriter;
        if (this.printWriter != null) {
            LoggerHelper.initializeLoggingOnWriter(this.printWriter);
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject sj) {
        this.subject = sj;
    }

    protected ConnectionRequestInfo getConnectionRequestInfo() {
        return this.crinfo;
    }

    protected void setConnectionRequestInfo(ConnectionRequestInfo info) {
        this.crinfo = info;
    }

    protected void sendEvent(ConnectionEvent coEvent) {
        for (ConnectionEventListener l : this.connectionEventListeners) {
            this.sendEventToListener(coEvent, l);
        }
    }

    protected void sendEventToListener(ConnectionEvent coEvent, ConnectionEventListener listener) {
        if (coEvent.getId() == 1) {
            listener.connectionClosed(coEvent);
            LOG.log(Level.FINE, "CONNECTION_CLOSED_EVENT_FIRED", new Object[]{listener});
        }
        if (coEvent.getId() == 3) {
            listener.localTransactionCommitted(coEvent);
            LOG.log(Level.FINE, "LOCAL_TX_COMMITTED_EVENT_FIRED", new Object[]{listener});
        }
        if (coEvent.getId() == 4) {
            listener.localTransactionRolledback(coEvent);
            LOG.log(Level.FINE, "LOCAL_TX_ROLLEDBACK_EVENT_FIRED", new Object[]{listener});
        }
        if (coEvent.getId() == 2) {
            listener.localTransactionStarted(coEvent);
            LOG.log(Level.FINE, "LOCAL_TX_STARTED_EVENT_FIRED", new Object[]{listener});
        }
        if (coEvent.getId() == 5) {
            listener.connectionErrorOccurred(coEvent);
            LOG.log(Level.FINE, "CTX_ERROR_OCURRED_EVENT_FIRED", new Object[]{listener});
        }
    }

    protected AbstractManagedConnectionFactoryImpl theManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ":" + this.hashCode() + ":ManagedConnection[" + String.valueOf(this.crinfo) + "]";
    }

    public void error(Exception ex) {
        LOG.warning(ex.toString());
        this.sendEvent(new ConnectionEvent((ManagedConnection)this, 5, ex));
    }
}

