/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import org.apache.activemq.artemis.core.management.impl.view.SessionField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ServerSession;

public class SessionFilterPredicate
extends ActiveMQFilterPredicate<ServerSession> {
    private SessionField f;

    @Override
    public boolean test(ServerSession session) {
        if (this.f == null) {
            return true;
        }
        return switch (this.f) {
            case SessionField.ID -> this.matches(session.getName());
            case SessionField.CONNECTION_ID -> this.matches(session.getConnectionID());
            case SessionField.CONSUMER_COUNT -> this.matches(session.getServerConsumers().size());
            case SessionField.PRODUCER_COUNT -> this.matches(session.getServerProducers().size());
            case SessionField.PROTOCOL -> this.matches(session.getRemotingConnection().getProtocolName());
            case SessionField.CLIENT_ID -> this.matches(session.getRemotingConnection().getClientID());
            case SessionField.LOCAL_ADDRESS -> this.matches(session.getRemotingConnection().getTransportConnection().getLocalAddress());
            case SessionField.REMOTE_ADDRESS -> this.matches(session.getRemotingConnection().getTransportConnection().getRemoteAddress());
            default -> true;
        };
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.isEmpty()) {
            this.f = SessionField.valueOfName(field);
            if (this.f == null) {
                this.f = SessionField.valueOf(field);
            }
        }
    }
}

