/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jgroups.BaseMessage;
import org.jgroups.BytesMessage;
import org.jgroups.EmptyMessage;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.NioMessage;
import org.jgroups.ObjectMessage;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.FRAG;
import org.jgroups.protocols.FRAG2;
import org.jgroups.protocols.FRAG3;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AckCollector;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class MessageSendTest
implements Receiver {
    protected JChannel ch;
    protected final AckCollector acks = new AckCollector();
    protected View view;
    protected static short ID = (short)5678;

    protected void start(String props, String name) throws Exception {
        this.ch = new JChannel(props).name(name).setReceiver(this).connect("demo");
        int len = MessageSendTest.findFragSize(this.ch) * 2;
        int i = 1;
        while (Util.keyPress(": ") != 120) {
            BaseMessage msg = new EmptyMessage();
            this.send(msg);
            msg = new BytesMessage(null, new byte[len]);
            this.send(msg);
            MyData obj = new MyData(i++, len);
            msg = new BytesMessage(null, obj);
            this.send(msg);
            msg = new ObjectMessage(null, obj);
            this.send(msg);
            obj = new MySizeData(i++, len);
            msg = new ObjectMessage(null, obj);
            this.send(msg);
            msg = new ObjectMessage(null, obj);
            this.send(msg);
            Person p = new Person("Bela Ban", 53, new byte[len]);
            msg = new ObjectMessage(null, p);
            this.send(msg);
            ByteBuffer b = ByteBuffer.wrap(new byte[len]);
            msg = new NioMessage(null, b);
            this.send(msg);
            byte[] tmp = new byte[len];
            b = ByteBuffer.allocateDirect(len).put(tmp);
            b.flip();
            msg = new NioMessage(null, b);
            this.send(msg);
        }
        Util.close((Closeable)this.ch);
    }

    protected void send(Message msg) throws Exception {
        boolean success;
        this.acks.reset(this.view.getMembers());
        System.out.printf("-- sending %s of %d bytes: ", msg.getClass().getSimpleName(), msg.getLength());
        this.ch.send(msg);
        try {
            success = this.acks.waitForAllAcks(5000L);
        }
        catch (TimeoutException ex) {
            success = false;
        }
        System.out.printf("%s\n", success ? "OK" : "FAIL");
    }

    protected static int findFragSize(JChannel ch) {
        Object prot = ch.getProtocolStack().findProtocol(FRAG.class, FRAG2.class, FRAG3.class);
        return prot != null ? (Integer)((Protocol)prot).getValue("frag_size") : 30000;
    }

    @Override
    public void receive(Message msg) {
        if (msg.getHeader((short)3344) != null) {
            this.acks.ack(msg.getSrc());
            return;
        }
        if (!msg.getSrc().equals(this.ch.getAddress())) {
            System.out.printf("-- received %d bytes from %s (msg type: %s)\n", msg.getLength(), msg.getSrc(), msg.getClass().getSimpleName());
        }
        try {
            this.ch.send(new EmptyMessage(msg.getSrc()).putHeader((short)3344, new MyHeader()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void viewAccepted(View view) {
        Object[] objectArray = new Object[1];
        this.view = view;
        objectArray[0] = this.view;
        System.out.printf("** view: %s\n", objectArray);
    }

    public static void main(String[] args) throws Exception {
        String props = null;
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-name".equals(args[i])) {
                name = args[++i];
                continue;
            }
            System.out.printf("%s [-props config] [-name name]\n", MessageSendTest.class.getSimpleName());
            return;
        }
        new MessageSendTest().start(props, name);
    }

    static {
        ClassConfigurator.add(ID, MyHeader.class);
    }

    protected static class Person
    implements Serializable {
        private static final long serialVersionUID = 8635045223414419580L;
        protected String name;
        protected int age;
        protected byte[] buf;

        public Person(String name, int age, byte[] buf) {
            this.name = name;
            this.age = age;
            this.buf = buf;
        }

        public String toString() {
            return String.format("name=%s age=%d bytes=%d", this.name, this.age, this.buf != null ? this.buf.length : 0);
        }
    }

    public static class MySizeData
    extends MyData
    implements SizeStreamable {
        public MySizeData() {
        }

        public MySizeData(int num, int length) {
            super(num, length);
        }

        public MySizeData(int num, byte[] buf) {
            super(num, buf);
        }

        @Override
        public int serializedSize() {
            return 8 + (this.data != null ? this.data.length : 0);
        }
    }

    public static class MyData
    implements Streamable {
        protected int num;
        protected byte[] data;

        public MyData() {
        }

        public MyData(int num, int length) {
            this.num = num;
            this.data = new byte[length];
        }

        public MyData(int num, byte[] buf) {
            this.num = num;
            this.data = buf;
        }

        public String toString() {
            return String.format("num=%d, data: %d bytes", this.num, this.data != null ? this.data.length : 0);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeInt(this.num);
            out.writeInt(this.data != null ? this.data.length : 0);
            if (this.data != null) {
                out.write(this.data, 0, this.data.length);
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            this.num = in.readInt();
            int len = in.readInt();
            if (len > 0) {
                this.data = new byte[len];
                in.readFully(this.data);
            }
        }
    }

    protected static class MyHeader
    extends Header {
        @Override
        public short getMagicId() {
            return ID;
        }

        @Override
        public Supplier<? extends Header> create() {
            return MyHeader::new;
        }

        @Override
        public int serializedSize() {
            return 0;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
        }
    }
}

