/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.harness.JavaVersionHolder;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.DropDatabaseSetup;
import org.apache.derbyTesting.junit.SpawnedProcess;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public abstract class BaseTestCase
extends TestCase {
    private static final String JACOCO_AGENT_PROP = "derby.tests.jacoco.agent";
    protected static final String ERRORSTACKTRACEFILE = "error-stacktrace.out";
    protected static final String DEFAULT_DB_DIR = "system";
    protected static final String DERBY_LOG = "derby.log";
    private static int debugPort;
    private static final PrintStream out;
    private static int spawnedCount;

    private BaseTestCase() {
    }

    public BaseTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        TestConfiguration config = this.getTestConfiguration();
        boolean trace = config.doTrace();
        boolean stopAfterFirstFail = config.stopAfterFirstFail();
        long startTime = 0L;
        if (trace) {
            startTime = System.currentTimeMillis();
            out.println();
            String junitClassName = ((Object)((Object)this)).getClass().getName();
            junitClassName = Utilities.formatTestClassNames(junitClassName);
            out.print(BaseTestCase.traceClientType());
            out.print(junitClassName + "." + this.getName() + " ");
        }
        try {
            super.runBare();
        }
        catch (Throwable running) {
            PrintWriter stackOut = null;
            try {
                String failPath = PrivilegedFileOpsForTests.getAbsolutePath(this.getFailureFolder());
                stackOut = new PrintWriter(PrivilegedFileOpsForTests.getFileOutputStream(new File(failPath, ERRORSTACKTRACEFILE), true));
                stackOut.println("[Error/failure logged at " + String.valueOf(new Date()) + "]");
                running.printStackTrace(stackOut);
                stackOut.println();
                File origLog = new File(DEFAULT_DB_DIR, DERBY_LOG);
                File newLog = new File(failPath, DERBY_LOG);
                PrivilegedFileOpsForTests.copy(origLog, newLog);
                for (int i = 0; i < 10; ++i) {
                    String logName = "derby-" + i + ".log";
                    File origRolLog = new File(DEFAULT_DB_DIR, logName);
                    File newRolLog = new File(failPath, logName);
                    PrivilegedFileOpsForTests.copy(origRolLog, newRolLog);
                }
                String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
                File dbDir = new File(DEFAULT_DB_DIR, dbName);
                File newDbDir = new File(failPath, dbName);
                PrivilegedFileOpsForTests.copy(dbDir, newDbDir);
            }
            catch (IOException ioe) {
                BaseTestCase.printStackTrace(ioe);
                if (stackOut != null) {
                    stackOut.println("Copying derby.log or database failed:");
                    ioe.printStackTrace(stackOut);
                    stackOut.println();
                }
            }
            finally {
                if (stackOut != null) {
                    stackOut.close();
                }
                if (!stopAfterFirstFail) {
                    throw running;
                }
                running.printStackTrace(out);
                System.exit(1);
            }
        }
        finally {
            if (trace) {
                long timeUsed = System.currentTimeMillis() - startTime;
                out.print("used " + timeUsed + " ms ");
            }
        }
    }

    public final TestConfiguration getTestConfiguration() {
        return TestConfiguration.getCurrent();
    }

    public final File getFailureFolder() {
        return this.getTestConfiguration().getFailureFolder(this);
    }

    public static void alarm(String text) {
        out.println("ALARM: " + text);
    }

    public static void println(String text) {
        if (TestConfiguration.getCurrent().isVerbose()) {
            out.println("DEBUG: " + text);
            out.flush();
        }
    }

    public static void traceit(String text) {
        if (TestConfiguration.getCurrent().doTrace()) {
            out.println(text);
        }
    }

    public static void printStackTrace(Throwable t) {
        while (t != null) {
            t.printStackTrace(out);
            out.flush();
            if (!(t instanceof SQLException)) break;
            t = ((SQLException)t).getNextException();
        }
    }

    protected static void setSystemOut(PrintStream out) {
        System.setOut(out);
    }

    protected static void setSystemErr(PrintStream err) {
        System.setErr(err);
    }

    protected static void setSystemProperty(String name, String value) {
        System.setProperty(name, value);
    }

    public static void removeSystemProperty(String name) {
        System.getProperties().remove(name);
    }

    protected static String getSystemProperty(String name) {
        return System.getProperty(name);
    }

    protected static String[] getFilesWith(File dir, String prefix) {
        FilenameFilter filefilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("javacore");
            }
        };
        return dir.list(filefilter);
    }

    protected static URL getTestResource(String name) {
        return BaseTestCase.class.getClassLoader().getResource(name);
    }

    protected static InputStream openTestResource(URL url) throws IOException {
        return url.openStream();
    }

    public static void assertEquals(InputStream is1, InputStream is2) throws IOException {
        if (is1 == null || is2 == null) {
            BaseTestCase.assertNull((String)"InputStream is2 is null, is1 is not", (Object)is1);
            BaseTestCase.assertNull((String)"InputStream is1 is null, is2 is not", (Object)is2);
            return;
        }
        long index = 0L;
        int b1 = is1.read();
        int b2 = is2.read();
        do {
            if (b1 != b2) {
                BaseTestCase.assertEquals((String)("Streams differ at index " + index), (int)b1, (int)b2);
            }
            ++index;
            b1 = is1.read();
            b2 = is2.read();
        } while (b1 != -1 || b2 != -1);
        is1.close();
        is2.close();
    }

    public static void assertEquals(Reader r1, Reader r2) throws IOException {
        long index = 0L;
        if (r1 == null || r2 == null) {
            BaseTestCase.assertNull((String)"Reader r2 is null, r1 is not", (Object)r1);
            BaseTestCase.assertNull((String)"Reader r1 is null, r2 is not", (Object)r2);
            return;
        }
        int c1 = r1.read();
        int c2 = r2.read();
        do {
            if (c1 != c2) {
                BaseTestCase.assertEquals((String)("Streams differ at index " + index), (int)c1, (int)c2);
            }
            ++index;
            c1 = r1.read();
            c2 = r2.read();
        } while (c1 != -1 || c2 != -1);
        r1.close();
        r2.close();
    }

    public static void assertThrowableEquals(Throwable t1, Throwable t2) {
        BaseTestCase.assertNotNull((String)"Passed-in throwable t1 cannot be null to assert detailed message", (Object)t1);
        BaseTestCase.assertNotNull((String)"Passed-in throwable t2 cannot be null to assert detailed message", (Object)t2);
        BaseTestCase.assertEquals((String)"Throwable class types are different", (String)t1.getClass().getName(), (String)t2.getClass().getName());
        BaseTestCase.assertEquals((String)"Detailed messages of the throwable's are different", (String)t1.getMessage(), (String)t2.getMessage());
    }

    public static void assertEquals(byte[] expected, byte[] actual) {
        if (BaseTestCase.assertSameNullness(expected, actual)) {
            return;
        }
        BaseTestCase.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            BaseTestCase.assertEquals((String)Integer.toString(i), (byte)expected[i], (byte)actual[i]);
        }
    }

    public static boolean assertSameNullness(Object expected, Object actual) {
        if (expected == null) {
            BaseTestCase.assertNull((Object)actual);
            return true;
        }
        BaseTestCase.assertNotNull((Object)actual);
        return false;
    }

    public static void assertEquals(int[] expected, int[] actual) {
        if (BaseTestCase.assertSameNullness(expected, actual)) {
            return;
        }
        BaseTestCase.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            BaseTestCase.assertEquals((String)Integer.toString(i), (int)expected[i], (int)actual[i]);
        }
    }

    public static void assertEquals(long[] expected, long[] actual) {
        if (BaseTestCase.assertSameNullness(expected, actual)) {
            return;
        }
        BaseTestCase.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            BaseTestCase.assertEquals((String)Integer.toString(i), (long)expected[i], (long)actual[i]);
        }
    }

    public static void assertEquals(File file1, File file2) {
        try {
            BufferedInputStream f1 = new BufferedInputStream(new FileInputStream(file1));
            BufferedInputStream f2 = new BufferedInputStream(new FileInputStream(file2));
            BaseTestCase.assertEquals(f1, f2);
        }
        catch (FileNotFoundException e) {
            BaseTestCase.fail((String)("FileNotFoundException in assertEquals(File,File): " + e.getMessage()));
            e.printStackTrace();
        }
        catch (IOException e) {
            BaseTestCase.fail((String)("IOException in assertEquals(File, File): " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void assertExecJavaCmdAsExpected(String[] expectedString, String[] cmd, int expectedExitValue) throws InterruptedException, IOException {
        int i;
        Process pr = BaseTestCase.execJavaCmd(cmd);
        String output = BaseTestCase.readProcessOutput(pr);
        int exitValue = pr.exitValue();
        Object expectedStrings = "";
        for (i = 0; i < expectedString.length; ++i) {
            expectedStrings = (String)expectedStrings + "\t[" + i + "]" + expectedString[i] + "\n";
        }
        Assert.assertEquals((String)("expectedExitValue:" + expectedExitValue + " does not match exitValue:" + exitValue + "\nexpected output strings:\n" + (String)expectedStrings + " actual output:" + output), (int)expectedExitValue, (int)exitValue);
        if (expectedString != null) {
            for (i = 0; i < expectedString.length; ++i) {
                BaseTestCase.assertTrue((String)("Could not find expectedString:" + expectedString[i] + " in output:" + output), (output.indexOf(expectedString[i]) >= 0 ? 1 : 0) != 0);
            }
        }
    }

    public static Process execJavaCmd(String jvm2, String cp, String[] cmd, File dir) throws IOException {
        return BaseTestCase.execJavaCmd(jvm2, cp, cmd, dir, true);
    }

    public static Process execJavaCmd(String jvm2, String cp, String[] cmd, File dir, boolean addClassPath) throws IOException {
        boolean useModules = JVMInfo.isModuleAware();
        return BaseTestCase.execJavaCmd(jvm2, cp, cmd, dir, addClassPath, useModules);
    }

    public static Process execJavaCmd(String jvm2, String cp, String[] cmd, File dir, boolean addClassPath, boolean useModulePath) throws IOException {
        boolean isJarInvocation = cmd.length > 0 && cmd[0].equals("-jar");
        ArrayList<String> cmdlist = new ArrayList<String>();
        cmdlist.add(jvm2 == null ? BaseTestCase.getJavaExecutableName() : jvm2);
        if (BaseTestCase.isJ9Platform()) {
            String jacocoactive;
            cmdlist.add("-jcl:foun11");
            String emmaactive = BaseTestCase.getSystemProperty("emma.active");
            if (emmaactive != null) {
                cmdlist.add("-Demma.active=" + emmaactive);
            }
            if ((jacocoactive = BaseTestCase.getSystemProperty("jacoco.active")) != null) {
                cmdlist.add("-Djacoco.active=" + jacocoactive);
            }
        }
        if (BaseTestCase.isCVM()) {
            cmdlist.add("-Xmx32M");
        }
        if (BaseTestCase.runsWithEmma()) {
            cmdlist.add("-Demma.coverage.out.file=" + String.valueOf(BaseTestCase.getEmmaOutFile()));
            if (cp != null) {
                cp = (String)cp + File.pathSeparator + BaseTestCase.getEmmaJar().getPath();
            }
            if (isJarInvocation) {
                cmdlist.add("-Xbootclasspath/a:" + BaseTestCase.getEmmaJar().getPath());
            }
        }
        if (BaseTestCase.runsWithJaCoCo()) {
            String agent;
            cmdlist.add(agent + ((agent = BaseTestCase.getSystemProperty(JACOCO_AGENT_PROP)).endsWith("=") ? "" : ",") + "destfile=" + String.valueOf(BaseTestCase.getJaCoCoOutFile()));
            cmdlist.add("-Djacoco.active=");
        }
        if (BaseTestCase.isSunJVM() && Boolean.valueOf(BaseTestCase.getSystemProperty("derby.test.debugSubprocesses")).booleanValue()) {
            BaseTestCase.setupForDebuggerAttach(cmdlist);
        }
        if (useModulePath) {
            cmdlist.add("--add-modules");
            cmdlist.add("org.apache.derby.tests,junit");
        }
        if (isJarInvocation) {
            BaseTestCase.assertNull((String)"Both -jar and classpath specified", (Object)cp);
        } else if (addClassPath) {
            Object myClasspath = cp != null ? cp : (useModulePath ? JVMInfo.getSystemModulePath() : BaseTestCase.getSystemProperty("java.class.path"));
            if (BaseTestCase.isWindowsPlatform()) {
                myClasspath = ((String)myClasspath).replace("file:/", "/");
            }
            if (useModulePath) {
                cmdlist.add("-p");
            } else {
                cmdlist.add("-classpath");
            }
            cmdlist.add((String)myClasspath);
        }
        for (int i = 0; i < cmd.length; ++i) {
            cmdlist.add(cmd[i]);
        }
        String[] command = cmdlist.toArray(cmd);
        BaseTestCase.println("execute java command:");
        for (int i = 0; i < command.length; ++i) {
            BaseTestCase.println("command[" + i + "]" + command[i]);
        }
        try {
            return Runtime.getRuntime().exec(command, (String[])null, dir);
        }
        catch (IOException pe) {
            BaseTestCase.println("Failed to run command: " + pe.getMessage());
            if (TestConfiguration.getCurrent().isVerbose()) {
                pe.printStackTrace(out);
                out.flush();
            }
            throw pe;
        }
    }

    public static Process execJavaCmd(String[] cmd) throws IOException {
        return BaseTestCase.execJavaCmd(null, null, cmd, null);
    }

    public static final String getJavaExecutableName() {
        Object vmname = BaseTestCase.getSystemProperty("com.ibm.oti.vm.exe");
        if (vmname == null) {
            vmname = BaseTestCase.getSystemProperty("java.vm.name");
            vmname = "CVM".equals(vmname) ? BaseTestCase.getSystemProperty("java.home") + File.separator + "bin" + File.separator + "cvm" : BaseTestCase.getSystemProperty("java.home") + File.separator + "bin" + File.separator + "java";
        }
        return vmname;
    }

    public static File currentDirectory() {
        return new File(BaseTestCase.getSystemProperty("user.dir"));
    }

    public static final boolean isJ9Platform() {
        return BaseTestCase.getSystemProperty("com.ibm.oti.vm.exe") != null;
    }

    public static final boolean isSunJVM() {
        String vendor = BaseTestCase.getSystemProperty("java.vendor");
        return "Sun Microsystems Inc.".equals(vendor) || "Oracle Corporation".equals(vendor);
    }

    public static boolean isCVM() {
        return "CVM".equals(BaseTestCase.getSystemProperty("java.vm.name"));
    }

    public static boolean isPhoneME() {
        return BaseTestCase.isCVM() && BaseTestCase.getSystemProperty("java.vm.version").startsWith("phoneme");
    }

    public static final boolean isPlatform(String osName) {
        return BaseTestCase.getSystemProperty("os.name").equals(osName);
    }

    public static final boolean isWindowsPlatform() {
        return BaseTestCase.getSystemProperty("os.name").startsWith("Windows");
    }

    public static final boolean shortCircuitFor_derby_7011() {
        boolean isModuleAware = JVMInfo.isModuleAware();
        boolean isJenkinsRun = BaseTestCase.getSystemProperty("user.dir").startsWith("/home/jenkins");
        return isModuleAware && isJenkinsRun;
    }

    public static final boolean isJava5() {
        return BaseTestCase.getSystemProperty("java.version").startsWith("1.5");
    }

    public static final boolean isJava7() {
        return BaseTestCase.getSystemProperty("java.version").startsWith("1.7");
    }

    public static final boolean isJava8() {
        return BaseTestCase.getSystemProperty("java.version").startsWith("1.8");
    }

    public static final boolean runsWithEmma() {
        return BaseTestCase.getSystemProperty("java.class.path").indexOf("emma.jar") != -1;
    }

    public static boolean runsWithJaCoCo() {
        return TestConfiguration.jacocoEnabled;
    }

    private static synchronized File getJaCoCoOutFile() {
        return new File(BaseTestCase.currentDirectory(), "jacoco.exec." + ++spawnedCount);
    }

    private static synchronized File getEmmaOutFile() {
        return new File(BaseTestCase.currentDirectory(), "coverage-" + ++spawnedCount + ".ec");
    }

    public static URL getEmmaJar() {
        return TestConfiguration.getURL("com.vladium.emma.EMMAException");
    }

    public static int getClassVersionMajor() {
        String tmp = BaseTestCase.getSystemProperty("java.class.version");
        if (tmp == null) {
            BaseTestCase.println("VM doesn't have property java.class.version");
            return -1;
        }
        int dot = tmp.indexOf(46);
        int major = -1;
        try {
            major = Integer.parseInt(tmp.substring(0, dot));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return major;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean hasInterruptibleIO() {
        boolean interruptibleIO = false;
        try {
            TestConfiguration curr = TestConfiguration.getCurrent();
            String sysHome = BaseTestCase.getSystemProperty("derby.system.home");
            StringBuffer arbitraryRAFFileNameB = new StringBuffer();
            arbitraryRAFFileNameB.append(sysHome);
            arbitraryRAFFileNameB.append(File.separatorChar);
            arbitraryRAFFileNameB.append(DERBY_LOG);
            String arbitraryRAFFileName = arbitraryRAFFileNameB.toString();
            new File(sysHome).mkdirs();
            new File(arbitraryRAFFileName).createNewFile();
            RandomAccessFile f = new RandomAccessFile(arbitraryRAFFileName, "r");
            try {
                Thread.currentThread().interrupt();
                f.read();
            }
            finally {
                Thread.interrupted();
                f.close();
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedIOException) {
                interruptibleIO = true;
            }
            BaseTestCase.println("Could not test for interruptible IO, so assuming we don't have it: " + String.valueOf(e));
            e.printStackTrace();
            return false;
        }
        return interruptibleIO;
    }

    public static final boolean isIBMJVM() {
        return "IBM Corporation".equals(BaseTestCase.getSystemProperty("java.vendor"));
    }

    public static String readProcessOutput(Process pr) throws InterruptedException {
        SpawnedProcess wrapper = new SpawnedProcess(pr, "readProcessOutput");
        wrapper.suppressOutputOnComplete();
        try {
            wrapper.complete();
        }
        catch (IOException ioe) {
            BaseTestCase.fail("process completion method failed", ioe);
        }
        String output = "<STDOUT>" + wrapper.getFullServerOutput() + "<END STDOUT>\n";
        output = output + "<STDERR>" + wrapper.getFullServerError() + "<END STDERR>\n";
        return output;
    }

    public static void assertDirectoryDeleted(File dir) {
        int i;
        StringBuffer sb;
        File[] fl = null;
        int attempts = 0;
        while (attempts < 4) {
            try {
                Thread.sleep(attempts * 2000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                fl = PrivilegedFileOpsForTests.persistentRecursiveDelete(dir);
                ++attempts;
            }
            catch (FileNotFoundException fnfe) {
                if (attempts == 0) {
                    BaseTestCase.fail((String)("directory doesn't exist: " + PrivilegedFileOpsForTests.getAbsolutePath(dir)));
                }
                System.out.println("<assertDirectoryDeleted> root directory unexpectedly gone - delayed, external or concurrent delete?");
                return;
            }
            if (fl.length == 0) {
                return;
            }
            sb = new StringBuffer();
            sb.append("<assertDirectoryDeleted> attempt ").append(attempts).append(" left ").append(fl.length).append(" files/dirs behind:");
            for (i = 0; i < fl.length; ++i) {
                sb.append(' ').append(i).append('=').append(fl[i]);
            }
            System.out.println(sb);
        }
        sb = new StringBuffer();
        for (i = 0; i < fl.length; ++i) {
            File f = fl[i];
            sb.append(PrivilegedFileOpsForTests.getAbsolutePath(f)).append(' ').append(PrivilegedFileOpsForTests.getFileInfo(f)).append(", ");
        }
        sb.deleteCharAt(sb.length() - 1).deleteCharAt(sb.length() - 1);
        BaseTestCase.fail((String)("Failed to delete " + fl.length + " files (root=" + PrivilegedFileOpsForTests.getAbsolutePath(dir) + "): " + sb.toString()));
    }

    public static void removeDirectory(String path) {
        DropDatabaseSetup.removeDirectory(path);
    }

    public static void removeDirectory(File dir) {
        DropDatabaseSetup.removeDirectory(dir);
    }

    public static void removeFiles(String[] list) {
        DropDatabaseSetup.removeFiles(list);
    }

    public static void fail(String msg, Throwable t) throws AssertionFailedError {
        throw BaseTestCase.newAssertionFailedError(msg, t);
    }

    public static AssertionFailedError newAssertionFailedError(String message, Throwable cause) {
        AssertionFailedError e = new AssertionFailedError(message);
        e.initCause(cause);
        return e;
    }

    public static void assertLaunchedJUnitTestMethod(String testLaunchMethod) throws Exception {
        String[] cmd = new String[]{"junit.textui.TestRunner", "-m", testLaunchMethod};
        BaseTestCase.assertExecJavaCmdAsExpected(new String[]{"OK (1 test)"}, cmd, 0);
    }

    public static void assertLaunchedJUnitTestMethod(String testLaunchMethod, String databaseName) throws Exception {
        String[] cmd = new String[]{"-Dderby.tests.defaultDatabaseName=" + databaseName, "junit.textui.TestRunner", "-m", testLaunchMethod};
        BaseTestCase.assertExecJavaCmdAsExpected(new String[]{"OK (1 test)"}, cmd, 0);
    }

    public static void sleepAtLeastOneTick() {
        long currentTime = System.currentTimeMillis();
        while (System.currentTimeMillis() == currentTime) {
            BaseTestCase.sleep(1L);
        }
    }

    public static boolean vmAtLeast(int major, int minor) {
        String version = System.getProperty("java.version");
        JavaVersionHolder jvh = new JavaVersionHolder(version);
        return jvh.atLeast(major, minor);
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ie) {
            BaseTestCase.alarm("sleep interrupted");
        }
    }

    private static String traceClientType() {
        if (TestConfiguration.getCurrent().getJDBCClient().isEmbedded()) {
            return "(emb)";
        }
        return "(net)";
    }

    private static void setupForDebuggerAttach(ArrayList<String> cmdlist) {
        if (debugPort == 0) {
            String dbp = BaseTestCase.getSystemProperty("derby.test.debugPortBase");
            debugPort = 8800;
            if (dbp != null) {
                try {
                    debugPort = Integer.parseInt(dbp);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        char suspend = 'y';
        String susp = BaseTestCase.getSystemProperty("derby.test.debugSuspend");
        if (susp != null && "n".equals(susp.toLowerCase())) {
            suspend = 'n';
        }
        cmdlist.add("-Xdebug");
        cmdlist.add("-Xrunjdwp:transport=dt_socket,address=" + debugPort++ + ",server=y,suspend=" + suspend);
    }

    static {
        out = System.out;
        spawnedCount = 0;
    }
}

