package org.apache.torque.templates.skipdecider;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.List;

import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.skipDecider.SkipDecider;
import org.apache.torque.templates.TemplateOptionName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.transformer.om.TableChildElementName;

/**
 * A skipSourceDecider which returns true if the option
 * "torque.om.useManagers" is true and the current table has a primary key.
 *
 * @version $Id: ManagerSkipDecider.java 1337528 2012-05-12 12:55:09Z tfischer $
 */
public class ManagerSkipDecider implements SkipDecider
{
    public boolean proceed(ControllerState controllerState)
    {
        if (!controllerState.getBooleanOption(
                TemplateOptionName.OM_USE_MANAGERS))
        {
            return false;
        }
        SourceElement sourceElement = controllerState.getSourceElement();
        if ("false".equals(sourceElement.getAttribute("useManagers")))
        {
            return false;
        }
        List<SourceElement> primaryKeyColumns
                = sourceElement.getChild(TableChildElementName.PRIMARY_KEYS)
                    .getChildren(TorqueSchemaElementName.COLUMN);
        return !primaryKeyColumns.isEmpty();
    }
}
