/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import org.apache.directory.api.ldap.model.filter.AbstractExprNode;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.FilterVisitor;
import org.apache.directory.api.ldap.model.schema.AttributeType;

public abstract class LeafNode
extends AbstractExprNode {
    protected AttributeType attributeType;
    protected String attribute;

    protected LeafNode(AttributeType attributeType, AssertionType assertionType) {
        super(assertionType);
        this.attributeType = attributeType;
        if (attributeType == null) {
            throw new NullPointerException("Cannot create a Node with a null Attribute");
        }
        this.attribute = attributeType.getName();
        this.isSchemaAware = true;
    }

    protected LeafNode(String attribute, AssertionType assertionType) {
        super(assertionType);
        this.attributeType = null;
        this.attribute = attribute;
        this.isSchemaAware = false;
    }

    @Override
    public final boolean isLeaf() {
        return true;
    }

    public final AttributeType getAttributeType() {
        return this.attributeType;
    }

    public final String getAttribute() {
        return this.attribute;
    }

    public void setAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
        if (attributeType != null) {
            this.attribute = attributeType.getName();
            this.isSchemaAware = true;
        }
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
        this.isSchemaAware = false;
    }

    @Override
    public final Object accept(FilterVisitor visitor) {
        if (visitor.canVisit(this)) {
            return visitor.visit(this);
        }
        return null;
    }

    @Override
    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = this.attributeType != null ? h * 17 + this.attributeType.hashCode() : h * 17 + this.attribute.hashCode();
        return h;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LeafNode)) {
            return false;
        }
        LeafNode otherNode = (LeafNode)other;
        if (other.getClass() != this.getClass()) {
            return false;
        }
        if (this.attributeType != null) {
            return this.attributeType.equals(otherNode.getAttributeType());
        }
        return this.attribute.equalsIgnoreCase(otherNode.getAttribute());
    }
}

