/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.MemoryEndPointPipe;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.strategy.AdaptiveExecutionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryConnector
extends AbstractConnector {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryConnector.class);
    private final SocketAddress socketAddress = new MemorySocketAddress();
    private final TaskProducer producer = new TaskProducer();
    private ExecutionStrategy strategy;

    public MemoryConnector(Server server, ConnectionFactory ... factories) {
        this(server, (Executor)null, (Scheduler)null, (ByteBufferPool)null, factories);
    }

    public MemoryConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, ConnectionFactory ... factories) {
        super(server, executor, scheduler, bufferPool, 0, factories);
    }

    @Override
    protected void doStart() throws Exception {
        this.strategy = new AdaptiveExecutionStrategy(this.producer, this.getExecutor());
        this.addBean(this.strategy);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.strategy);
    }

    @Override
    public Object getTransport() {
        return null;
    }

    @Override
    protected void accept(int acceptorID) throws IOException, InterruptedException {
    }

    public EndPoint.Pipe connect() {
        MemoryEndPointPipe pipe = new MemoryEndPointPipe(this.getScheduler(), this.producer::offer, this.socketAddress);
        this.accept(pipe.getRemoteEndPoint());
        if (LOG.isDebugEnabled()) {
            LOG.debug("connected {} to {}", (Object)pipe, (Object)this);
        }
        return pipe;
    }

    private void accept(final EndPoint endPoint) {
        endPoint.setIdleTimeout(this.getIdleTimeout());
        AbstractConnection connection = (AbstractConnection)this.getDefaultConnectionFactory().newConnection(this, endPoint);
        endPoint.setConnection(connection);
        endPoint.onOpen();
        this.onEndPointOpened(endPoint);
        connection.addEventListener(new Connection.Listener(){
            final /* synthetic */ MemoryConnector this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onClosed(Connection connection) {
                this.this$0.onEndPointClosed(endPoint);
            }
        });
        connection.onOpen();
        if (LOG.isDebugEnabled()) {
            LOG.debug("accepted {} in {}", (Object)endPoint, (Object)this);
        }
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socketAddress;
    }

    private class MemorySocketAddress
    extends SocketAddress {
        private final String address;

        private MemorySocketAddress() {
            this.address = "[memory:@%x]".formatted(System.identityHashCode(MemoryConnector.this));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof MemorySocketAddress) {
                MemorySocketAddress that = (MemorySocketAddress)obj;
                return this.address.equals(that.address);
            }
            return false;
        }

        public int hashCode() {
            return this.address.hashCode();
        }

        public String toString() {
            return this.address;
        }
    }

    private class TaskProducer
    implements ExecutionStrategy.Producer {
        private final Queue<Invocable.Task> tasks = new ConcurrentLinkedQueue<Invocable.Task>();

        private TaskProducer() {
        }

        @Override
        public Runnable produce() {
            return this.tasks.poll();
        }

        private void offer(Invocable.Task task) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("offer {} to {}", (Object)task, (Object)MemoryConnector.this);
            }
            this.tasks.offer(task);
            MemoryConnector.this.strategy.produce();
        }
    }
}

