/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.DataflowQueue;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.SyncDataflowVariable;
import groovyx.gpars.dataflow.operator.ChainWithClosure;
import groovyx.gpars.dataflow.operator.CopyChannelsClosure;
import groovyx.gpars.group.PGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SyncDataflowQueue<T>
extends DataflowQueue<T> {
    @Override
    protected DataflowVariable<T> createVariable() {
        return new SyncDataflowVariable(1);
    }

    @Override
    public <V> DataflowReadChannel<V> chainWith(PGroup group, Closure<V> closure) {
        SyncDataflowQueue<T> result = new SyncDataflowQueue<T>();
        group.operator(this, result, new ChainWithClosure(closure));
        return result;
    }

    @Override
    public DataflowReadChannel<T> tap(PGroup group, DataflowWriteChannel<T> target) {
        SyncDataflowVariable result = new SyncDataflowVariable();
        group.operator(Arrays.asList(this), Arrays.asList(result, target), new ChainWithClosure(new CopyChannelsClosure()));
        return result;
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        SyncDataflowQueue<T> result = new SyncDataflowQueue<T>();
        ArrayList<DataflowReadChannel<Object>> inputs = new ArrayList<DataflowReadChannel<Object>>();
        inputs.add(this);
        inputs.addAll(others);
        group.operator(inputs, Arrays.asList(result), new ChainWithClosure(closure));
        return result;
    }

    @Override
    public String toString() {
        return "SyncDataflowQueue(queue=" + new ArrayList(this.getQueue()).toString() + ')';
    }
}

