/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx;

import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tx.TxPriority;

public class TransactionIds {
    public static UUID transactionId(HybridTimestamp beginTimestamp, int nodeId, TxPriority priority) {
        return TransactionIds.transactionId(beginTimestamp.longValue(), nodeId, priority);
    }

    public static UUID transactionId(HybridTimestamp beginTimestamp, int nodeId) {
        return TransactionIds.transactionId(beginTimestamp.longValue(), nodeId, TxPriority.NORMAL);
    }

    public static UUID transactionId(long beginTimestamp, int nodeId, TxPriority priority) {
        return new UUID(beginTimestamp, TransactionIds.combine(nodeId, priority));
    }

    public static HybridTimestamp beginTimestamp(UUID transactionId) {
        return HybridTimestamp.hybridTimestamp(transactionId.getMostSignificantBits());
    }

    public static int nodeId(UUID transactionId) {
        return (int)(transactionId.getLeastSignificantBits() >> 32);
    }

    public static TxPriority priority(UUID txId) {
        int ordinal = (int)(txId.getLeastSignificantBits() & 1L);
        return TxPriority.fromOrdinal(ordinal);
    }

    private static long combine(int nodeId, TxPriority priority) {
        int priorityAsInt = priority.ordinal();
        return (long)nodeId << 32 | (long)priorityAsInt;
    }
}

