/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.metrics.RaftLogMetrics;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogEntryHeader;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.server.raftlog.RaftLogSequentialOps;
import org.apache.ratis.server.storage.RaftStorageMetadata;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RaftLog
extends RaftLogSequentialOps,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(RaftLog.class);
    public static final long LEAST_VALID_LOG_INDEX = 0L;
    public static final long INVALID_LOG_INDEX = -1L;

    default public boolean contains(TermIndex ti) {
        Objects.requireNonNull(ti, "ti == null");
        return ti.equals(this.getTermIndex(ti.getIndex()));
    }

    public TermIndex getTermIndex(long var1);

    public RaftProtos.LogEntryProto get(long var1) throws RaftLogIOException;

    public EntryWithData getEntryWithData(long var1) throws RaftLogIOException;

    public LogEntryHeader[] getEntries(long var1, long var3);

    public long getStartIndex();

    default public long getNextIndex() {
        TermIndex last = this.getLastEntryTermIndex();
        if (last == null) {
            return this.getLastCommittedIndex() + 1L;
        }
        return last.getIndex() + 1L;
    }

    public long getLastCommittedIndex();

    public long getSnapshotIndex();

    public long getFlushIndex();

    public TermIndex getLastEntryTermIndex();

    public RaftLogMetrics getRaftLogMetrics();

    public boolean updateCommitIndex(long var1, long var3, boolean var5);

    public void updateSnapshotIndex(long var1);

    public void open(long var1, Consumer<RaftProtos.LogEntryProto> var3) throws IOException;

    public CompletableFuture<Long> purge(long var1);

    public void persistMetadata(RaftStorageMetadata var1) throws IOException;

    public RaftStorageMetadata loadMetadata() throws IOException;

    public CompletableFuture<Long> onSnapshotInstalled(long var1);

    public static interface EntryWithData {
        public int getSerializedSize();

        public RaftProtos.LogEntryProto getEntry(TimeDuration var1) throws RaftLogIOException, TimeoutException;
    }
}

