/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class Tree<A> {
    private final List<Tree<A>> children = new ArrayList<Tree<A>>();
    private final Tree<A> parent;
    private final A value;

    public Tree(@Nullable Tree<A> parent, A value) {
        this.parent = parent;
        this.value = value;
    }

    public Tree<A> addChild(A value) {
        return this.addChild(new Tree<A>(this, value));
    }

    public Tree<A> addChild(Tree<A> child) {
        this.children.add(child);
        return child;
    }

    @Nullable
    public Tree<A> getParent() {
        return this.parent;
    }

    public List<Tree<A>> getChildren() {
        return this.children;
    }

    public A getValue() {
        return this.value;
    }

    public void traverse(Consumer<A> c) {
        Tree.traverse(this, (a, integer) -> c.accept(a), 0);
    }

    public void traverseNodes(Consumer<Tree<A>> c) {
        Tree.traverseNodes(this, (t, integer) -> c.accept((Tree)t), 0);
    }

    public void traverseWithDepth(BiConsumer<A, Integer> c) {
        Tree.traverse(this, c, 0);
    }

    public void traverseWithParent(BiConsumer<A, A> c) {
        Tree.traverse(this, c);
    }

    public <B> Tree<B> map(Function<A, B> f) {
        return Tree.map(this, f);
    }

    private static <A, B> Tree<B> map(Tree<A> tA, Function<A, B> f) {
        Tree<B> tB = new Tree<B>(null, f.apply(tA.value));
        Tree.map(tA, tB, f);
        return tB;
    }

    private static <A, B> void map(Tree<A> tA, Tree<B> tB, Function<A, B> f) {
        tA.children.forEach(cA -> {
            Tree cB = tB.addChild(f.apply(cA.value));
            Tree.map(cA, cB, f);
        });
    }

    private static <T> void traverse(Tree<T> tree, BiConsumer<T, Integer> c, int depth) {
        Object value = tree.value;
        c.accept(value, depth);
        tree.children.forEach(t -> Tree.traverse(t, c, depth + 1));
    }

    private static <T> void traverseNodes(Tree<T> tree, BiConsumer<Tree<T>, Integer> c, int depth) {
        c.accept(tree, depth);
        tree.children.forEach(t -> Tree.traverseNodes(t, c, depth + 1));
    }

    private static <T> void traverse(Tree<T> tree, BiConsumer<T, T> c) {
        Object parentValue = tree.parent != null ? (Object)tree.parent.value : null;
        Object value = tree.value;
        c.accept(value, parentValue);
        tree.children.forEach(t -> Tree.traverse(t, c));
    }
}

