/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;

public class DigestUtil {
    private static final ThreadLocal<MessageDigest> sha1Digest = new ThreadLocal();

    public static byte[] sha1(byte[] input) {
        MessageDigest messageDigest = sha1Digest.get();
        if (messageDigest == null) {
            try {
                messageDigest = MessageDigest.getInstance("SHA1");
                sha1Digest.set(messageDigest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new UaRuntimeException(0x80020000L, (Throwable)e);
            }
        }
        return messageDigest.digest(input);
    }
}

