/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class AddNodesResult
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=483");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=485");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=484");
    private final StatusCode statusCode;
    private final NodeId addedNodeId;

    public AddNodesResult(StatusCode statusCode, NodeId addedNodeId) {
        this.statusCode = statusCode;
        this.addedNodeId = addedNodeId;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public NodeId getAddedNodeId() {
        return this.addedNodeId;
    }

    protected AddNodesResult(AddNodesResultBuilder<?, ?> b) {
        super(b);
        this.statusCode = ((AddNodesResultBuilder)b).statusCode;
        this.addedNodeId = ((AddNodesResultBuilder)b).addedNodeId;
    }

    public static AddNodesResultBuilder<?, ?> builder() {
        return new AddNodesResultBuilderImpl();
    }

    public AddNodesResultBuilder<?, ?> toBuilder() {
        return new AddNodesResultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddNodesResult)) {
            return false;
        }
        AddNodesResult other = (AddNodesResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StatusCode this$statusCode = this.getStatusCode();
        StatusCode other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        NodeId this$addedNodeId = this.getAddedNodeId();
        NodeId other$addedNodeId = other.getAddedNodeId();
        return !(this$addedNodeId == null ? other$addedNodeId != null : !((Object)this$addedNodeId).equals(other$addedNodeId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddNodesResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatusCode $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        NodeId $addedNodeId = this.getAddedNodeId();
        result = result * 59 + ($addedNodeId == null ? 43 : ((Object)$addedNodeId).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AddNodesResult(statusCode=" + this.getStatusCode() + ", addedNodeId=" + this.getAddedNodeId() + ")";
    }

    private static final class AddNodesResultBuilderImpl
    extends AddNodesResultBuilder<AddNodesResult, AddNodesResultBuilderImpl> {
        private AddNodesResultBuilderImpl() {
        }

        @Override
        protected AddNodesResultBuilderImpl self() {
            return this;
        }

        @Override
        public AddNodesResult build() {
            return new AddNodesResult(this);
        }
    }

    public static abstract class AddNodesResultBuilder<C extends AddNodesResult, B extends AddNodesResultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private StatusCode statusCode;
        private NodeId addedNodeId;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AddNodesResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AddNodesResult instance, AddNodesResultBuilder<?, ?> b) {
            b.statusCode(instance.statusCode);
            b.addedNodeId(instance.addedNodeId);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return (B)this.self();
        }

        public B addedNodeId(NodeId addedNodeId) {
            this.addedNodeId = addedNodeId;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AddNodesResult.AddNodesResultBuilder(super=" + super.toString() + ", statusCode=" + this.statusCode + ", addedNodeId=" + this.addedNodeId + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<AddNodesResult> {
        @Override
        public Class<AddNodesResult> getType() {
            return AddNodesResult.class;
        }

        @Override
        public AddNodesResult decode(SerializationContext context, UaDecoder decoder) {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            NodeId addedNodeId = decoder.readNodeId("AddedNodeId");
            return new AddNodesResult(statusCode, addedNodeId);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, AddNodesResult value) {
            encoder.writeStatusCode("StatusCode", value.getStatusCode());
            encoder.writeNodeId("AddedNodeId", value.getAddedNodeId());
        }
    }
}

