/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.unsafequeues;

public class VirtualPointer
implements Comparable<VirtualPointer> {
    final long logicalOffset;

    public static VirtualPointer buildUntouched() {
        return new VirtualPointer(-1L);
    }

    public VirtualPointer(long logicalOffset) {
        this.logicalOffset = logicalOffset;
    }

    @Override
    public int compareTo(VirtualPointer other) {
        return Long.compare(this.logicalOffset, other.logicalOffset);
    }

    public long segmentOffset(int segmentSize) {
        return this.logicalOffset % (long)segmentSize;
    }

    public long logicalOffset() {
        return this.logicalOffset;
    }

    public VirtualPointer moveForward(long delta) {
        return new VirtualPointer(this.logicalOffset + delta);
    }

    public VirtualPointer plus(int i) {
        return new VirtualPointer(this.logicalOffset + (long)i);
    }

    public boolean isGreaterThan(VirtualPointer other) {
        return this.compareTo(other) > 0;
    }

    public boolean isUntouched() {
        return this.logicalOffset == -1L;
    }

    public VirtualPointer copy() {
        return new VirtualPointer(this.logicalOffset);
    }

    public String toString() {
        return "VirtualPointer{logicalOffset=" + this.logicalOffset + '}';
    }
}

