/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.Message;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.JmsMessageHelper;
import org.apache.camel.component.jms.reply.CorrelationTimeoutMap;
import org.apache.camel.component.jms.reply.QueueReplyHandler;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.component.jms.reply.ReplyHolder;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.listener.AbstractMessageListenerContainer;

public abstract class ReplyManagerSupport
extends ServiceSupport
implements ReplyManager {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final CamelContext camelContext;
    protected ScheduledExecutorService scheduledExecutorService;
    protected ExecutorService executorService;
    protected JmsEndpoint endpoint;
    protected Destination replyTo;
    protected AbstractMessageListenerContainer listenerContainer;
    protected final CountDownLatch replyToLatch = new CountDownLatch(1);
    protected final long replyToTimeout = 10000L;
    protected CorrelationTimeoutMap correlation;
    protected String correlationProperty;

    public ReplyManagerSupport(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService executorService) {
        this.scheduledExecutorService = executorService;
    }

    @Override
    public void setOnTimeoutExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public void setEndpoint(JmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setReplyTo(Destination replyTo) {
        this.log.trace("ReplyTo destination: {}", (Object)replyTo);
        this.replyTo = replyTo;
        this.replyToLatch.countDown();
    }

    @Override
    public void setCorrelationProperty(String correlationProperty) {
        this.correlationProperty = correlationProperty;
    }

    @Override
    public Destination getReplyTo() {
        if (this.replyTo != null) {
            return this.replyTo;
        }
        try {
            this.log.trace("Waiting for replyTo to be set");
            boolean done = this.replyToLatch.await(10000L, TimeUnit.MILLISECONDS);
            if (!done) {
                this.log.warn("ReplyTo destination was not set and timeout occurred");
            } else {
                this.log.trace("Waiting for replyTo to be set done");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.replyTo;
    }

    @Override
    public String registerReply(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long requestTimeout) {
        QueueReplyHandler handler = new QueueReplyHandler(replyManager, exchange, callback, originalCorrelationId, correlationId, requestTimeout);
        ReplyHandler result = this.correlation.putIfAbsent(correlationId, handler, requestTimeout);
        if (result != null) {
            String logMessage = String.format("The correlationId [%s] is not unique.", correlationId);
            throw new IllegalArgumentException(logMessage);
        }
        return correlationId;
    }

    protected abstract ReplyHandler createReplyHandler(ReplyManager var1, Exchange var2, AsyncCallback var3, String var4, String var5, long var6);

    public void onMessage(javax.jms.Message message, Session session) throws JMSException {
        String correlationID = null;
        try {
            correlationID = this.correlationProperty == null ? message.getJMSCorrelationID() : message.getStringProperty(this.correlationProperty);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        if (correlationID == null) {
            this.log.warn("Ignoring message with no correlationID: {}", (Object)message);
            return;
        }
        this.log.debug("Received reply message with correlationID [{}] -> {}", (Object)correlationID, (Object)message);
        this.handleReplyMessage(correlationID, message, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processReply(ReplyHolder holder) {
        if (holder != null && this.isRunAllowed()) {
            try {
                Exchange exchange = holder.getExchange();
                boolean timeout = holder.isTimeout();
                if (timeout) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("Timeout occurred after {} millis waiting for reply message with correlationID [{}] on destination {}. Setting ExchangeTimedOutException on {} and continue routing.", new Object[]{holder.getRequestTimeout(), holder.getCorrelationId(), this.replyTo, ExchangeHelper.logIds((Exchange)exchange)});
                    }
                    String msg = "reply message with correlationID: " + holder.getCorrelationId() + " not received on destination: " + this.replyTo;
                    exchange.setException((Throwable)new ExchangeTimedOutException(exchange, holder.getRequestTimeout(), msg));
                } else {
                    javax.jms.Message message = holder.getMessage();
                    Session session = holder.getSession();
                    JmsMessage response = new JmsMessage(exchange, message, session, this.endpoint.getBinding());
                    exchange.setOut((Message)response);
                    Object body = response.getBody();
                    if (this.endpoint.isTransferException() && body instanceof Exception) {
                        this.log.debug("Reply was an Exception. Setting the Exception on the Exchange: {}", body);
                        exchange.setException((Throwable)((Exception)body));
                    } else {
                        this.log.debug("Reply received. OUT message body set to reply payload: {}", body);
                    }
                    if (holder.getOriginalCorrelationId() != null) {
                        JmsMessageHelper.setCorrelationId(message, holder.getOriginalCorrelationId());
                        exchange.getOut().setHeader("JMSCorrelationID", (Object)holder.getOriginalCorrelationId());
                    }
                }
            }
            finally {
                AsyncCallback callback = holder.getCallback();
                callback.done(false);
            }
        }
    }

    protected abstract void handleReplyMessage(String var1, javax.jms.Message var2, Session var3);

    protected abstract AbstractMessageListenerContainer createListenerContainer() throws Exception;

    protected ReplyHandler waitForProvisionCorrelationToBeUpdated(String correlationID, javax.jms.Message message) {
        if (this.log.isWarnEnabled()) {
            this.log.warn("Early reply received with correlationID [{}] -> {}", (Object)correlationID, (Object)message);
        }
        ReplyHandler answer = null;
        boolean done = false;
        int counter = 0;
        while (!done && counter++ < this.endpoint.getConfiguration().getWaitForProvisionCorrelationToBeUpdatedCounter()) {
            this.log.trace("Early reply not found handler at attempt {}. Waiting a bit longer.", (Object)counter);
            try {
                Thread.sleep(this.endpoint.getConfiguration().getWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            answer = (ReplyHandler)this.correlation.get(correlationID);
            boolean bl = done = answer != null;
            if (answer == null || !this.log.isTraceEnabled()) continue;
            this.log.trace("Early reply with correlationID [{}] has been matched after {} attempts and can be processed using handler: {}", new Object[]{correlationID, counter, answer});
        }
        return answer;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.executorService, (String)"executorService", (Object)this);
        ObjectHelper.notNull((Object)this.scheduledExecutorService, (String)"scheduledExecutorService", (Object)this);
        ObjectHelper.notNull((Object)((Object)this.endpoint), (String)"endpoint", (Object)this);
        this.log.trace("Using timeout checker interval with {} millis", (Object)this.endpoint.getRequestTimeoutCheckerInterval());
        this.correlation = new CorrelationTimeoutMap(this.scheduledExecutorService, this.endpoint.getRequestTimeoutCheckerInterval(), this.executorService);
        ServiceHelper.startService((Object)((Object)this.correlation));
        this.listenerContainer = this.createListenerContainer();
        this.listenerContainer.afterPropertiesSet();
        this.log.debug("Starting reply listener container on endpoint: {}", (Object)this.endpoint);
        this.endpoint.onListenerContainerStarting(this.listenerContainer);
        this.listenerContainer.start();
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)((Object)this.correlation));
        if (this.listenerContainer != null) {
            this.log.debug("Stopping reply listener container on endpoint: {}", (Object)this.endpoint);
            try {
                this.listenerContainer.stop();
                this.listenerContainer.destroy();
            }
            finally {
                this.endpoint.onListenerContainerStopped(this.listenerContainer);
                this.listenerContainer = null;
            }
        }
        if (this.scheduledExecutorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownGraceful((ExecutorService)this.scheduledExecutorService);
            this.scheduledExecutorService = null;
        }
        if (this.executorService != null) {
            this.camelContext.getExecutorServiceManager().shutdownGraceful(this.executorService);
            this.executorService = null;
        }
    }
}

