/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.sshd.client.proxy.ProxyData;
import org.apache.sshd.client.session.proxy.AbstractProxyConnector;
import org.apache.sshd.client.session.proxy.AuthenticationChallenge;
import org.apache.sshd.client.session.proxy.AuthenticationHandler;
import org.apache.sshd.client.session.proxy.BasicAuthentication;
import org.apache.sshd.client.session.proxy.GssApiAuthentication;
import org.apache.sshd.client.session.proxy.GssApiMechanisms;
import org.apache.sshd.client.session.proxy.HttpParser;
import org.apache.sshd.client.session.proxy.StatusLine;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.functors.IOFunction;
import org.ietf.jgss.GSSContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyConnector
extends AbstractProxyConnector {
    private static final Logger LOG = LoggerFactory.getLogger(HttpProxyConnector.class);
    private static final String HTTP_V11 = "HTTP/1.1";
    private static final String HTTP_HEADER_PROXY_AUTHENTICATE = "Proxy-Authenticate:";
    private static final String HTTP_HEADER_PROXY_AUTHORIZATION = "Proxy-Authorization:";
    private HttpAuthenticationHandler basic = new HttpBasicAuthentication();
    private HttpAuthenticationHandler negotiate = new NegotiateAuthentication();
    private List<HttpAuthenticationHandler> availableAuthentications = new ArrayList<HttpAuthenticationHandler>(2);
    private Iterator<HttpAuthenticationHandler> clientAuthentications;
    private HttpAuthenticationHandler authenticator;
    private boolean ongoing;

    public HttpProxyConnector(ProxyData proxy, InetSocketAddress remoteAddress, IOFunction<Buffer, IoWriteFuture> send, Function<InetSocketAddress, PasswordAuthentication> passwordAuth) {
        super(proxy, remoteAddress, send, passwordAuth);
        this.availableAuthentications.add(this.negotiate);
        this.availableAuthentications.add(this.basic);
        this.clientAuthentications = this.availableAuthentications.iterator();
    }

    @Override
    public void close() {
        super.close();
        HttpAuthenticationHandler current = this.authenticator;
        this.authenticator = null;
        if (current != null) {
            current.close();
        }
    }

    @Override
    public void start() throws IOException {
        StringBuilder msg = this.connect();
        if (this.proxyUser != null && !this.proxyUser.isEmpty() || this.proxyPassword != null && this.proxyPassword.length > 0) {
            this.authenticator = this.basic;
            this.basic.setParams(null);
            this.basic.start();
            msg = this.authenticate(msg, (String)this.basic.getToken());
            this.clearPassword();
            this.proxyUser = null;
        }
        this.ongoing = true;
        try {
            this.send(msg);
        }
        catch (IOException e) {
            this.ongoing = false;
            throw e;
        }
    }

    private void send(StringBuilder msg) throws IOException {
        byte[] data = this.eol(msg).toString().getBytes(StandardCharsets.US_ASCII);
        ByteArrayBuffer buffer = new ByteArrayBuffer(data.length, false);
        buffer.putRawBytes(data);
        this.write((Buffer)buffer);
    }

    private StringBuilder connect() {
        StringBuilder msg = new StringBuilder();
        return msg.append(MessageFormat.format("CONNECT {0}:{1} {2}\r\nProxy-Connection: keep-alive\r\nConnection: keep-alive\r\nHost: {0}:{1}\r\n", this.remoteAddress.getHostString(), Integer.toString(this.remoteAddress.getPort()), HTTP_V11));
    }

    private StringBuilder authenticate(StringBuilder msg, String token) {
        msg.append(HTTP_HEADER_PROXY_AUTHORIZATION).append(' ').append(token);
        return this.eol(msg);
    }

    private StringBuilder eol(StringBuilder msg) {
        return msg.append('\r').append('\n');
    }

    @Override
    public Buffer received(Readable buffer) throws Exception {
        try {
            int length = buffer.available();
            byte[] data = new byte[length];
            buffer.getRawBytes(data, 0, length);
            ByteArrayBuffer rest = null;
            String msg = new String(data, StandardCharsets.US_ASCII);
            int end = msg.indexOf("\r\n\r\n");
            end = end < 0 ? data.length : (end += 4);
            if (end < data.length) {
                msg = msg.substring(0, end);
                data = Arrays.copyOfRange(data, end, data.length);
                rest = new ByteArrayBuffer(data);
            }
            String[] reply = msg.split("\r\n");
            this.handleMessage(Arrays.asList(reply));
            return rest;
        }
        catch (Exception e) {
            if (this.authenticator != null) {
                this.authenticator.close();
                this.authenticator = null;
            }
            this.ongoing = false;
            this.done = true;
            throw e;
        }
    }

    private void handleMessage(List<String> reply) throws Exception {
        if (reply.isEmpty() || reply.get(0).isEmpty()) {
            throw new IOException("Unexpected empty reply from proxy " + this.proxyAddress);
        }
        try {
            StatusLine status = HttpParser.parseStatusLine(reply.get(0));
            if (!this.ongoing) {
                throw new IOException(MessageFormat.format("Unexpected reply from proxy {0}; {1} status {2}: {3}", this.proxyAddress, status.getVersion(), Integer.toString(status.getResultCode()), status.getReason()));
            }
            switch (status.getResultCode()) {
                case 200: {
                    if (this.authenticator != null) {
                        this.authenticator.close();
                    }
                    this.authenticator = null;
                    this.ongoing = false;
                    this.done = true;
                    break;
                }
                case 407: {
                    boolean closesConnection = reply.stream().anyMatch("Connection: close"::equals);
                    if (closesConnection) {
                        LOG.warn("{} proxy closed connection; needs up-front pre-emptive proxy authentication", (Object)status.getVersion());
                    }
                    List<AuthenticationChallenge> challenges = HttpParser.getAuthenticationHeaders(reply, HTTP_HEADER_PROXY_AUTHENTICATE);
                    this.authenticator = this.selectProtocol(challenges, this.authenticator);
                    if (this.authenticator == null) {
                        throw new IOException("Cannot authenticate at proxy " + this.proxyAddress);
                    }
                    String token = (String)this.authenticator.getToken();
                    if (token == null) {
                        throw new IOException("Cannot authenticate at proxy " + this.proxyAddress);
                    }
                    this.send(this.authenticate(this.connect(), token));
                    break;
                }
                default: {
                    throw new IOException(MessageFormat.format("HTTP proxy failure at {0}, HTTP status {1}: {2}", this.proxyAddress, Integer.toString(status.getResultCode()), status.getReason()));
                }
            }
        }
        catch (HttpParser.ParseException e) {
            throw new IOException(MessageFormat.format("Cannot parse reply from proxy {0}: {1}", this.proxyAddress, reply.get(0)), e);
        }
    }

    private HttpAuthenticationHandler selectProtocol(List<AuthenticationChallenge> challenges, HttpAuthenticationHandler current) throws Exception {
        AuthenticationChallenge challenge;
        if (current != null && !current.isDone() && (challenge = this.getByName(challenges, current.getName())) != null) {
            current.setParams(challenge);
            current.process();
            return current;
        }
        if (current != null) {
            current.close();
        }
        while (this.clientAuthentications.hasNext()) {
            AuthenticationChallenge challenge2;
            HttpAuthenticationHandler next = this.clientAuthentications.next();
            if (next.isDone() || (challenge2 = this.getByName(challenges, next.getName())) == null) continue;
            next.setParams(challenge2);
            next.start();
            return next;
        }
        return null;
    }

    private AuthenticationChallenge getByName(List<AuthenticationChallenge> challenges, String name) {
        return challenges.stream().filter(c -> c.getMechanism().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    private class HttpBasicAuthentication
    extends BasicAuthentication<AuthenticationChallenge, String>
    implements HttpAuthenticationHandler {
        private boolean asked;

        HttpBasicAuthentication() {
            super(HttpProxyConnector.this.proxyAddress, HttpProxyConnector.this.proxyUser, HttpProxyConnector.this.proxyPassword);
        }

        @Override
        public String getName() {
            return "Basic";
        }

        @Override
        protected void askCredentials() {
            if (this.asked) {
                throw new IllegalStateException("Basic auth: already asked user for password");
            }
            this.asked = true;
            super.askCredentials();
            this.done = true;
        }

        @Override
        protected PasswordAuthentication getCredentials() {
            return HttpProxyConnector.this.passwordAuthentication();
        }

        @Override
        public String getToken() throws IOException {
            if (this.user.indexOf(58) >= 0) {
                throw new IOException(MessageFormat.format("Invalid user name ''{0}'' for proxy {1}", this.user, this.proxy));
            }
            byte[] rawUser = this.user.getBytes(StandardCharsets.UTF_8);
            byte[] toEncode = new byte[rawUser.length + 1 + this.password.length];
            System.arraycopy(rawUser, 0, toEncode, 0, rawUser.length);
            toEncode[rawUser.length] = 58;
            System.arraycopy(this.password, 0, toEncode, rawUser.length + 1, this.password.length);
            Arrays.fill(this.password, (byte)0);
            String result = Base64.getEncoder().encodeToString(toEncode);
            Arrays.fill(toEncode, (byte)0);
            return this.getName() + ' ' + result;
        }
    }

    private static interface HttpAuthenticationHandler
    extends AuthenticationHandler<AuthenticationChallenge, String> {
        public String getName();
    }

    private class NegotiateAuthentication
    extends GssApiAuthentication<AuthenticationChallenge, String>
    implements HttpAuthenticationHandler {
        NegotiateAuthentication() {
            super(HttpProxyConnector.this.proxyAddress);
        }

        @Override
        public String getName() {
            return "Negotiate";
        }

        @Override
        public String getToken() {
            return this.getName() + ' ' + Base64.getEncoder().encodeToString(this.token);
        }

        @Override
        protected GSSContext createContext() throws Exception {
            return GssApiMechanisms.createContext(GssApiMechanisms.SPNEGO, GssApiMechanisms.getCanonicalName(HttpProxyConnector.this.proxyAddress));
        }

        @Override
        protected byte[] extractToken(AuthenticationChallenge input) {
            String received = input.getToken();
            if (received == null) {
                return new byte[0];
            }
            return Base64.getDecoder().decode(received);
        }
    }
}

