/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.invoke;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.EdmEnabledODataClient;
import org.apache.olingo.client.api.communication.request.invoke.EdmEnabledInvokeRequestFactory;
import org.apache.olingo.client.api.communication.request.invoke.ODataInvokeRequest;
import org.apache.olingo.client.api.domain.ClientInvokeResult;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.core.communication.request.invoke.AbstractInvokeRequestFactory;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.http.HttpMethod;

public abstract class AbstractEdmEnabledInvokeRequestFactory
extends AbstractInvokeRequestFactory
implements EdmEnabledInvokeRequestFactory {
    private final EdmEnabledODataClient edmClient;

    public AbstractEdmEnabledInvokeRequestFactory(EdmEnabledODataClient edmClient) {
        this.edmClient = edmClient;
    }

    public <RES extends ClientInvokeResult> ODataInvokeRequest<RES> getFunctionImportInvokeRequest(String functionImportName) {
        return this.getFunctionImportInvokeRequest(functionImportName, null);
    }

    public <RES extends ClientInvokeResult> ODataInvokeRequest<RES> getFunctionImportInvokeRequest(String functionImportName, Map<String, ClientValue> parameters) {
        EdmFunctionImport efi = null;
        for (EdmSchema schema : this.edmClient.getCachedEdm().getSchemas()) {
            EdmEntityContainer container = schema.getEntityContainer();
            if (container == null) continue;
            efi = container.getFunctionImport(functionImportName);
        }
        if (efi == null) {
            throw new IllegalArgumentException("Could not find FunctionImport for name " + functionImportName);
        }
        EdmFunction function = this.edmClient.getCachedEdm().getUnboundFunction(efi.getFunctionFqn(), (List)(parameters == null ? null : new ArrayList<String>(parameters.keySet())));
        if (function == null) {
            throw new IllegalArgumentException("Could not find Function " + efi.getFunctionFqn());
        }
        return this.getInvokeRequest(HttpMethod.GET, this.edmClient.newURIBuilder().appendOperationCallSegment(functionImportName).build(), this.getResultReference(function.getReturnType()), parameters);
    }

    public <RES extends ClientInvokeResult> ODataInvokeRequest<RES> getActionImportInvokeRequest(String actionImportName) {
        return this.getActionImportInvokeRequest(actionImportName, null);
    }

    public <RES extends ClientInvokeResult> ODataInvokeRequest<RES> getActionImportInvokeRequest(String actionImportName, Map<String, ClientValue> parameters) {
        EdmActionImport eai = null;
        for (EdmSchema schema : this.edmClient.getCachedEdm().getSchemas()) {
            EdmEntityContainer container = schema.getEntityContainer();
            if (container == null) continue;
            eai = container.getActionImport(actionImportName);
        }
        if (eai == null) {
            throw new IllegalArgumentException("Could not find ActionImport for name " + actionImportName);
        }
        return this.getInvokeRequest(HttpMethod.POST, this.edmClient.newURIBuilder().appendOperationCallSegment(actionImportName).build(), this.getResultReference(eai.getUnboundAction().getReturnType()), parameters);
    }

    public <RES extends ClientInvokeResult> ODataInvokeRequest<RES> getBoundFunctionInvokeRequest(URI bindingParameterURI, FullQualifiedName functionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection) {
        return this.getBoundFunctionInvokeRequest(bindingParameterURI, functionName, bindingParameterTypeName, isBindingParameterCollection, null);
    }

    public <RES extends ClientInvokeResult> ODataInvokeRequest<RES> getBoundFunctionInvokeRequest(URI bindingParameterURI, FullQualifiedName functionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection, Map<String, ClientValue> parameters) {
        EdmFunction function = this.edmClient.getCachedEdm().getBoundFunction(functionName, bindingParameterTypeName, isBindingParameterCollection, (List)(parameters == null ? null : new ArrayList<String>(parameters.keySet())));
        if (function == null) {
            throw new IllegalArgumentException("Could not find Function for name " + functionName);
        }
        return this.getInvokeRequest(HttpMethod.GET, this.edmClient.newURIBuilder(bindingParameterURI.toASCIIString()).appendOperationCallSegment(function.getFullQualifiedName().toString()).build(), this.getResultReference(function.getReturnType()), parameters);
    }

    public <RES extends ClientInvokeResult> ODataInvokeRequest<RES> getBoundActionInvokeRequest(URI bindingParameterURI, FullQualifiedName actionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection) {
        return this.getBoundActionInvokeRequest(bindingParameterURI, actionName, bindingParameterTypeName, isBindingParameterCollection, null);
    }

    public <RES extends ClientInvokeResult> ODataInvokeRequest<RES> getBoundActionInvokeRequest(URI bindingParameterURI, FullQualifiedName actionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection, Map<String, ClientValue> parameters) {
        EdmAction action = this.edmClient.getCachedEdm().getBoundAction(actionName, bindingParameterTypeName, isBindingParameterCollection);
        if (action == null) {
            throw new IllegalArgumentException("Could not find Action for name " + actionName);
        }
        return this.getInvokeRequest(HttpMethod.POST, this.edmClient.newURIBuilder(bindingParameterURI.toASCIIString()).appendOperationCallSegment(action.getFullQualifiedName().toString()).build(), this.getResultReference(action.getReturnType()), parameters);
    }
}

