/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.metadatavalidator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlReferentialConstraint;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlStructuralType;

public class CsdlTypeValidator {
    private Map<String, String> aliasNamespaceMap = new HashMap<String, String>();
    private Map<FullQualifiedName, CsdlEntityContainer> csdlContainersMap = new HashMap<FullQualifiedName, CsdlEntityContainer>();
    private Map<FullQualifiedName, CsdlEntityType> csdlEntityTypesMap = new HashMap<FullQualifiedName, CsdlEntityType>();
    private Map<FullQualifiedName, CsdlComplexType> csdlComplexTypesMap = new HashMap<FullQualifiedName, CsdlComplexType>();
    private Map<FullQualifiedName, CsdlAction> csdlActionsMap = new HashMap<FullQualifiedName, CsdlAction>();
    private Map<FullQualifiedName, CsdlFunction> csdlFunctionsMap = new HashMap<FullQualifiedName, CsdlFunction>();
    private static final String V4_SCHEMA_XMLNS = "http://docs.oasis-open.org/odata/ns/edm";

    public CsdlTypeValidator() {
    }

    public CsdlTypeValidator(Map<String, String> aliasNamespaceMap, Map<FullQualifiedName, CsdlEntityContainer> csdlContainersMap, Map<FullQualifiedName, CsdlEntityType> csdlEntityTypesMap, Map<FullQualifiedName, CsdlComplexType> csdlComplexTypesMap, Map<FullQualifiedName, CsdlAction> csdlActionsMap, Map<FullQualifiedName, CsdlFunction> csdlFunctionsMap) {
        this.aliasNamespaceMap = aliasNamespaceMap;
        this.csdlContainersMap = csdlContainersMap;
        this.csdlEntityTypesMap = csdlEntityTypesMap;
        this.csdlComplexTypesMap = csdlComplexTypesMap;
        this.csdlActionsMap = csdlActionsMap;
        this.csdlFunctionsMap = csdlFunctionsMap;
    }

    public void validateMetadataXML() {
        this.validateCsdlEntityTypes();
        this.validateCsdlComplexTypes();
        this.validateCsdlEntitySet();
        this.validateCsdlActionImport();
        this.validateCsdlFunctionImport();
    }

    private void validateCsdlEntityTypes() {
        for (Map.Entry<FullQualifiedName, CsdlEntityType> entityTypes : this.csdlEntityTypesMap.entrySet()) {
            if (entityTypes.getValue() == null || entityTypes.getKey() == null) continue;
            CsdlEntityType entityType = entityTypes.getValue();
            if (entityType.getBaseType() != null) {
                CsdlEntityType baseEntityType;
                FullQualifiedName baseTypeFQName = entityType.getBaseTypeFQN();
                if (!this.csdlEntityTypesMap.containsKey(baseTypeFQName)) {
                    FullQualifiedName fqName = this.validateCsdlEntityTypeWithAlias(baseTypeFQName);
                    baseEntityType = this.fetchLastCsdlBaseType(fqName);
                } else {
                    baseEntityType = this.fetchLastCsdlBaseType(baseTypeFQName);
                }
                if (baseEntityType == null || baseEntityType.getKey() != null && !baseEntityType.getKey().isEmpty()) continue;
                throw new RuntimeException("Missing key for EntityType " + baseEntityType.getName());
            }
            if (entityType.getKey() != null && !entityType.getKey().isEmpty()) continue;
            throw new RuntimeException("Missing key for EntityType " + entityType.getName());
        }
    }

    private CsdlEntityType fetchLastCsdlBaseType(FullQualifiedName baseTypeFQName) {
        CsdlEntityType baseEntityType = null;
        while (baseTypeFQName != null) {
            if (!this.csdlEntityTypesMap.containsKey(baseTypeFQName)) {
                baseTypeFQName = this.validateCsdlEntityTypeWithAlias(baseTypeFQName);
            }
            if ((baseEntityType = this.csdlEntityTypesMap.get(baseTypeFQName)) == null) continue;
            if (baseEntityType.getKey() != null) break;
            if (baseEntityType.getBaseType() != null) {
                baseTypeFQName = baseEntityType.getBaseTypeFQN();
                continue;
            }
            if (baseEntityType.getBaseType() != null) continue;
            break;
        }
        return baseEntityType;
    }

    private CsdlNavigationProperty fetchLastBaseEntityHavingNavigationProperty(FullQualifiedName baseTypeFQName, String navBindingProperty) {
        CsdlEntityType baseEntityType = null;
        while (baseTypeFQName != null) {
            if (!this.csdlEntityTypesMap.containsKey(baseTypeFQName)) {
                baseTypeFQName = this.validateCsdlEntityTypeWithAlias(baseTypeFQName);
            }
            if ((baseEntityType = this.csdlEntityTypesMap.get(baseTypeFQName)) == null) continue;
            if (baseEntityType.getNavigationProperty(navBindingProperty) != null) break;
            if (baseEntityType.getBaseType() != null) {
                baseTypeFQName = baseEntityType.getBaseTypeFQN();
                continue;
            }
            if (baseEntityType.getBaseType() != null) continue;
        }
        if (baseEntityType == null) {
            throw new RuntimeException("Entity Type is null with fully qualified name:" + baseTypeFQName);
        }
        return baseEntityType.getNavigationProperty(navBindingProperty);
    }

    private FullQualifiedName validateCsdlEntityTypeWithAlias(FullQualifiedName fQName) {
        String namespace = this.aliasNamespaceMap.get(fQName.getNamespace());
        FullQualifiedName fqName = new FullQualifiedName(namespace, fQName.getName());
        if (!this.csdlEntityTypesMap.containsKey(fqName)) {
            throw new RuntimeException("Invalid Entity Type " + fQName);
        }
        return fqName;
    }

    private FullQualifiedName fetchCorrectNamespaceFromAlias(FullQualifiedName fqName) {
        if (this.aliasNamespaceMap.containsKey(fqName.getNamespace())) {
            String namespace = this.aliasNamespaceMap.get(fqName.getNamespace());
            fqName = new FullQualifiedName(namespace, fqName.getName());
        }
        return fqName;
    }

    private void validateCsdlComplexTypes() {
        for (Map.Entry<FullQualifiedName, CsdlComplexType> complexTypes : this.csdlComplexTypesMap.entrySet()) {
            FullQualifiedName baseTypeFQName;
            CsdlComplexType complexType;
            if (complexTypes.getValue() == null || complexTypes.getKey() == null || (complexType = complexTypes.getValue()).getBaseType() == null || this.csdlComplexTypesMap.containsKey(baseTypeFQName = complexType.getBaseTypeFQN())) continue;
            this.validateCsdlComplexTypeWithAlias(baseTypeFQName);
        }
    }

    private FullQualifiedName validateCsdlComplexTypeWithAlias(FullQualifiedName aliasName) {
        String namespace = this.aliasNamespaceMap.get(aliasName.getNamespace());
        FullQualifiedName fqName = new FullQualifiedName(namespace, aliasName.getName());
        if (!this.csdlComplexTypesMap.containsKey(fqName)) {
            throw new RuntimeException("Invalid Complex BaseType " + aliasName);
        }
        return fqName;
    }

    private void validateCsdlEntitySet() {
        for (Map.Entry<FullQualifiedName, CsdlEntityContainer> container : this.csdlContainersMap.entrySet()) {
            for (CsdlEntitySet entitySet : container.getValue().getEntitySets()) {
                FullQualifiedName entityType = entitySet.getTypeFQN();
                if (!this.csdlEntityTypesMap.containsKey(entityType)) {
                    this.validateCsdlEntityTypeWithAlias(entityType);
                }
                this.validateNavigationBindingPaths(entitySet, container);
            }
        }
    }

    private void validateNavigationBindingPaths(CsdlEntitySet entitySet, Map.Entry<FullQualifiedName, CsdlEntityContainer> container) {
        List navigationPropertyBindings = entitySet.getNavigationPropertyBindings();
        if (!navigationPropertyBindings.isEmpty()) {
            for (CsdlNavigationPropertyBinding navigationPropertyBinding : navigationPropertyBindings) {
                String navBindingPath = navigationPropertyBinding.getPath();
                String navBindingTarget = navigationPropertyBinding.getTarget();
                CsdlEntityType sourceEntityType = null;
                sourceEntityType = !this.csdlEntityTypesMap.containsKey(new FullQualifiedName(entitySet.getType())) ? this.csdlEntityTypesMap.get(this.validateCsdlEntityTypeWithAlias(new FullQualifiedName(entitySet.getType()))) : this.csdlEntityTypesMap.get(new FullQualifiedName(entitySet.getType()));
                CsdlNavigationProperty navProperty = null;
                String targetType = null;
                if (navBindingPath.contains("/")) {
                    navProperty = this.findLastQualifiedNameHavingNavigationProperty(navBindingPath, sourceEntityType);
                } else {
                    navProperty = sourceEntityType.getNavigationProperty(navBindingPath);
                    if (navProperty == null) {
                        navProperty = this.fetchLastBaseEntityHavingNavigationProperty(sourceEntityType.getBaseTypeFQN(), navBindingPath);
                    }
                }
                if (navBindingTarget.contains("/")) {
                    targetType = this.findLastQualifiedTargetName(navBindingTarget);
                } else {
                    if (container.getValue().getEntitySet(navBindingTarget) == null) {
                        if (container.getValue().getSingleton(navBindingTarget) != null) {
                            throw new RuntimeException("Validations of Singletons are not supported: " + navBindingTarget);
                        }
                        throw new RuntimeException("Navigation Property Target " + navBindingTarget + " is not part of the same container " + container.getKey());
                    }
                    FullQualifiedName fqName = container.getValue().getEntitySet(navBindingTarget).getTypeFQN();
                    if (!this.csdlEntityTypesMap.containsKey(fqName)) {
                        fqName = this.validateCsdlEntityTypeWithAlias(fqName);
                    }
                    targetType = fqName.getFullQualifiedNameAsString();
                }
                FullQualifiedName navFQName = this.fetchCorrectNamespaceFromAlias(navProperty.getTypeFQN());
                this.validateReferentialConstraint(sourceEntityType, this.csdlEntityTypesMap.get(new FullQualifiedName(targetType)), navProperty);
                if (navFQName.getFullQualifiedNameAsString().equals(targetType) || this.csdlEntityTypesMap.get(navFQName).getBaseTypeFQN() != null && this.fetchCorrectNamespaceFromAlias(this.csdlEntityTypesMap.get(navFQName).getBaseTypeFQN()).getFullQualifiedNameAsString().equals(targetType)) continue;
                throw new RuntimeException("Navigation Property Type " + navFQName + " does not match the binding target type " + targetType);
            }
        }
    }

    private void validateReferentialConstraint(CsdlEntityType sourceEntityType, CsdlEntityType targetEntityType, CsdlNavigationProperty navProperty) {
        if (!navProperty.getReferentialConstraints().isEmpty()) {
            String propertyName = ((CsdlReferentialConstraint)navProperty.getReferentialConstraints().get(0)).getProperty();
            if (sourceEntityType.getProperty(propertyName) == null) {
                throw new RuntimeException("Property name " + propertyName + " not part of the source entity.");
            }
            String referencedPropertyName = ((CsdlReferentialConstraint)navProperty.getReferentialConstraints().get(0)).getReferencedProperty();
            if (targetEntityType.getProperty(referencedPropertyName) == null) {
                throw new RuntimeException("Property name " + referencedPropertyName + " not part of the target entity.");
            }
        }
    }

    private String findLastQualifiedTargetName(String navBindingTarget) {
        CsdlEntityContainer csdlContainer;
        String[] targetPaths = navBindingTarget.split("/");
        CsdlEntityContainer csdlEntityContainer = csdlContainer = this.csdlContainersMap.containsKey(new FullQualifiedName(targetPaths[0])) ? this.csdlContainersMap.get(new FullQualifiedName(targetPaths[0])) : this.csdlContainersMap.get(this.fetchCorrectNamespaceFromAlias(new FullQualifiedName(targetPaths[0])));
        if (csdlContainer == null) {
            throw new RuntimeException("Container with FullyQualifiedName " + targetPaths[0] + " not found.");
        }
        String targetEntitySetName = targetPaths[1];
        CsdlEntitySet csdlEntitySet = csdlContainer.getEntitySet(targetEntitySetName);
        if (csdlEntitySet == null) {
            throw new RuntimeException("Target Entity Set mentioned in navigationBindingProperty not found in the container " + csdlContainer.getName());
        }
        FullQualifiedName fqName = csdlEntitySet.getTypeFQN();
        if (!this.csdlEntityTypesMap.containsKey(fqName)) {
            fqName = this.validateCsdlEntityTypeWithAlias(fqName);
        }
        return fqName.getFullQualifiedNameAsString();
    }

    private CsdlNavigationProperty findLastQualifiedNameHavingNavigationProperty(String navBindingPath, CsdlEntityType sourceEntityType) {
        CsdlEntityType sourceEntityTypeHavingNavProp;
        String[] paths = navBindingPath.split("/");
        String lastFullQualifiedName = "";
        for (String path : paths) {
            if (!path.contains(".")) continue;
            lastFullQualifiedName = path;
        }
        String strNavProperty = paths[paths.length - 1];
        String remainingPath = navBindingPath.substring(navBindingPath.indexOf(lastFullQualifiedName) + lastFullQualifiedName.length() + (lastFullQualifiedName.length() == 0 ? 0 : 1), navBindingPath.lastIndexOf(strNavProperty));
        if (remainingPath.length() > 0) {
            remainingPath = remainingPath.substring(0, remainingPath.length() - 1);
        }
        CsdlNavigationProperty navProperty = null;
        CsdlEntityType csdlEntityType = lastFullQualifiedName.length() == 0 ? sourceEntityType : (sourceEntityTypeHavingNavProp = this.csdlEntityTypesMap.containsKey(new FullQualifiedName(lastFullQualifiedName)) ? this.csdlEntityTypesMap.get(new FullQualifiedName(lastFullQualifiedName)) : this.csdlEntityTypesMap.get(this.fetchCorrectNamespaceFromAlias(new FullQualifiedName(lastFullQualifiedName))));
        if (sourceEntityTypeHavingNavProp == null) {
            CsdlComplexType sourceComplexTypeHavingNavProp;
            CsdlComplexType csdlComplexType = sourceComplexTypeHavingNavProp = this.csdlComplexTypesMap.containsKey(new FullQualifiedName(lastFullQualifiedName)) ? this.csdlComplexTypesMap.get(new FullQualifiedName(lastFullQualifiedName)) : this.csdlComplexTypesMap.get(this.fetchCorrectNamespaceFromAlias(new FullQualifiedName(lastFullQualifiedName)));
            if (sourceComplexTypeHavingNavProp == null) {
                throw new RuntimeException("The fully Qualified type " + lastFullQualifiedName + " mentioned in navigation binding path not found ");
            }
            navProperty = remainingPath.length() > 0 ? this.fetchNavigationProperty(remainingPath, strNavProperty, (CsdlStructuralType)sourceComplexTypeHavingNavProp) : sourceComplexTypeHavingNavProp.getNavigationProperty(strNavProperty);
        } else {
            navProperty = remainingPath.length() > 0 ? this.fetchNavigationProperty(remainingPath, strNavProperty, (CsdlStructuralType)sourceEntityTypeHavingNavProp) : sourceEntityTypeHavingNavProp.getNavigationProperty(strNavProperty);
        }
        return navProperty;
    }

    private CsdlNavigationProperty fetchNavigationProperty(String remainingPath, String strNavProperty, CsdlStructuralType sourceTypeHavingNavProp) {
        String[] paths;
        for (String path : paths = remainingPath.split("/")) {
            FullQualifiedName fqName = null;
            if (sourceTypeHavingNavProp instanceof CsdlComplexType) {
                fqName = ((CsdlComplexType)sourceTypeHavingNavProp).getProperty(path).getTypeAsFQNObject();
            } else if (sourceTypeHavingNavProp instanceof CsdlEntityType) {
                fqName = ((CsdlEntityType)sourceTypeHavingNavProp).getProperty(path).getTypeAsFQNObject();
            }
            if (fqName != null) {
                String namespace = this.aliasNamespaceMap.get(fqName.getNamespace());
                fqName = namespace != null ? new FullQualifiedName(namespace, fqName.getName()) : fqName;
            }
            sourceTypeHavingNavProp = this.csdlEntityTypesMap.get(fqName) != null ? (CsdlStructuralType)this.csdlEntityTypesMap.get(fqName) : (CsdlStructuralType)this.csdlComplexTypesMap.get(fqName);
        }
        return sourceTypeHavingNavProp.getNavigationProperty(strNavProperty);
    }

    private void validateCsdlActionImport() {
        for (Map.Entry<FullQualifiedName, CsdlEntityContainer> container : this.csdlContainersMap.entrySet()) {
            for (CsdlActionImport actionImport : container.getValue().getActionImports()) {
                FullQualifiedName fqaction = actionImport.getActionFQN();
                if (this.csdlActionsMap.containsKey(fqaction)) continue;
                this.validateCsdlActionsWithAlias(fqaction);
            }
        }
    }

    private FullQualifiedName validateCsdlActionsWithAlias(FullQualifiedName aliasName) {
        String namespace = this.aliasNamespaceMap.get(aliasName.getNamespace());
        FullQualifiedName fqName = new FullQualifiedName(namespace, aliasName.getName());
        if (!this.csdlActionsMap.containsKey(fqName)) {
            throw new RuntimeException("Invalid Action " + aliasName);
        }
        return fqName;
    }

    private void validateCsdlFunctionImport() {
        for (Map.Entry<FullQualifiedName, CsdlEntityContainer> container : this.csdlContainersMap.entrySet()) {
            for (CsdlFunctionImport functionImport : container.getValue().getFunctionImports()) {
                FullQualifiedName fqaction = functionImport.getFunctionFQN();
                if (this.csdlFunctionsMap.containsKey(fqaction)) continue;
                this.validateCsdlFunctionsWithAlias(fqaction);
            }
        }
    }

    private FullQualifiedName validateCsdlFunctionsWithAlias(FullQualifiedName aliasName) {
        String namespace = this.aliasNamespaceMap.get(aliasName.getNamespace());
        FullQualifiedName fqName = new FullQualifiedName(namespace, aliasName.getName());
        if (!this.csdlFunctionsMap.containsKey(fqName)) {
            throw new RuntimeException("Invalid Function " + aliasName);
        }
        return fqName;
    }

    public boolean isV4MetaData(XMLMetadata xmlMetadata) throws Exception {
        boolean isV4doc = true;
        List schemaNameSpaces = xmlMetadata.getSchemaNamespaces();
        if (schemaNameSpaces == null || schemaNameSpaces.isEmpty()) {
            throw new Exception("Cannot determine if v4 metadata,No schemanamespaces found in XMLMetadata");
        }
        for (List nameSpaces : schemaNameSpaces) {
            if (nameSpaces.contains(V4_SCHEMA_XMLNS)) continue;
            isV4doc = false;
        }
        return isV4doc;
    }

    public boolean isServiceDocument(XMLMetadata xmlMetadata) {
        boolean isServDoc = false;
        List schemas = xmlMetadata.getSchemas();
        for (CsdlSchema schema : schemas) {
            if (schema.getEntityContainer() == null) continue;
            isServDoc = true;
            break;
        }
        return isServDoc;
    }
}

