/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.config;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;

public class HystrixThreadPoolConfiguration {
    private final HystrixThreadPoolKey threadPoolKey;
    private final int coreSize;
    private final int maximumSize;
    private final int actualMaximumSize;
    private final int maxQueueSize;
    private final int queueRejectionThreshold;
    private final int keepAliveTimeInMinutes;
    private final boolean allowMaximumSizeToDivergeFromCoreSize;
    private final int rollingCounterNumberOfBuckets;
    private final int rollingCounterBucketSizeInMilliseconds;

    private HystrixThreadPoolConfiguration(HystrixThreadPoolKey threadPoolKey, int coreSize, int maximumSize, int actualMaximumSize, int maxQueueSize, int queueRejectionThreshold, int keepAliveTimeInMinutes, boolean allowMaximumSizeToDivergeFromCoreSize, int rollingCounterNumberOfBuckets, int rollingCounterBucketSizeInMilliseconds) {
        this.threadPoolKey = threadPoolKey;
        this.allowMaximumSizeToDivergeFromCoreSize = allowMaximumSizeToDivergeFromCoreSize;
        this.coreSize = coreSize;
        this.maximumSize = maximumSize;
        this.actualMaximumSize = actualMaximumSize;
        this.maxQueueSize = maxQueueSize;
        this.queueRejectionThreshold = queueRejectionThreshold;
        this.keepAliveTimeInMinutes = keepAliveTimeInMinutes;
        this.rollingCounterNumberOfBuckets = rollingCounterNumberOfBuckets;
        this.rollingCounterBucketSizeInMilliseconds = rollingCounterBucketSizeInMilliseconds;
    }

    private HystrixThreadPoolConfiguration(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties threadPoolProperties) {
        this(threadPoolKey, threadPoolProperties.coreSize().get(), threadPoolProperties.maximumSize().get(), threadPoolProperties.actualMaximumSize(), threadPoolProperties.maxQueueSize().get(), threadPoolProperties.queueSizeRejectionThreshold().get(), threadPoolProperties.keepAliveTimeMinutes().get(), threadPoolProperties.getAllowMaximumSizeToDivergeFromCoreSize().get(), threadPoolProperties.metricsRollingStatisticalWindowBuckets().get(), threadPoolProperties.metricsRollingStatisticalWindowInMilliseconds().get());
    }

    public static HystrixThreadPoolConfiguration sample(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties threadPoolProperties) {
        return new HystrixThreadPoolConfiguration(threadPoolKey, threadPoolProperties);
    }

    public HystrixThreadPoolKey getThreadPoolKey() {
        return this.threadPoolKey;
    }

    public int getCoreSize() {
        return this.coreSize;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public int getActualMaximumSize() {
        return this.actualMaximumSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public int getQueueRejectionThreshold() {
        return this.queueRejectionThreshold;
    }

    public int getKeepAliveTimeInMinutes() {
        return this.keepAliveTimeInMinutes;
    }

    public boolean getAllowMaximumSizeToDivergeFromCoreSize() {
        return this.allowMaximumSizeToDivergeFromCoreSize;
    }

    public int getRollingCounterNumberOfBuckets() {
        return this.rollingCounterNumberOfBuckets;
    }

    public int getRollingCounterBucketSizeInMilliseconds() {
        return this.rollingCounterBucketSizeInMilliseconds;
    }
}

