/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.util.Collections;
import java.util.Map;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.core.convert.ConversionService;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public abstract class ConfigurationUtils {
    public static void bind(Object o, Map<String, Object> properties, String configurationPropertyName, String bindingName, Validator validator) {
        ConfigurationUtils.bind(o, properties, configurationPropertyName, bindingName, validator, null);
    }

    public static void bind(Object o, Map<String, Object> properties, String configurationPropertyName, String bindingName, Validator validator, ConversionService conversionService) {
        Object toBind = ConfigurationUtils.getTargetObject(o);
        new Binder(Collections.singletonList(new MapConfigurationPropertySource(properties)), null, conversionService).bind(configurationPropertyName, Bindable.ofInstance(toBind));
        if (validator != null) {
            BeanPropertyBindingResult errors = new BeanPropertyBindingResult(toBind, bindingName);
            validator.validate(toBind, (Errors)errors);
            if (errors.hasErrors()) {
                throw new RuntimeException((Throwable)new BindException((BindingResult)errors));
            }
        }
    }

    public static <T> T getTargetObject(Object candidate) {
        try {
            if (AopUtils.isAopProxy((Object)candidate) && candidate instanceof Advised) {
                return (T)((Advised)candidate).getTargetSource().getTarget();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return (T)candidate;
    }
}

