/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.archaius;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConfigurationManager;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.cloud.netflix.archaius.ConfigurableEnvironmentConfiguration;

public class ArchaiusEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    public ArchaiusEndpoint() {
        super("archaius");
    }

    public Map<String, Object> invoke() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        if (config instanceof ConcurrentCompositeConfiguration) {
            ConcurrentCompositeConfiguration composite = (ConcurrentCompositeConfiguration)config;
            for (Configuration item : composite.getConfigurations()) {
                this.append(map, item);
            }
        } else {
            this.append(map, (Configuration)config);
        }
        return map;
    }

    private void append(Map<String, Object> map, Configuration config) {
        if (config instanceof ConfigurableEnvironmentConfiguration) {
            return;
        }
        if (config instanceof SystemConfiguration) {
            return;
        }
        if (config instanceof EnvironmentConfiguration) {
            return;
        }
        Iterator iter = config.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            map.put(key, config.getProperty(key));
        }
    }
}

