/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign;

import feign.Logger;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.ErrorDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="feign.client")
public class FeignClientProperties {
    private boolean defaultToProperties = true;
    private String defaultConfig = "default";
    private Map<String, FeignClientConfiguration> config = new HashMap<String, FeignClientConfiguration>();

    public boolean isDefaultToProperties() {
        return this.defaultToProperties;
    }

    public void setDefaultToProperties(boolean defaultToProperties) {
        this.defaultToProperties = defaultToProperties;
    }

    public String getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(String defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    public Map<String, FeignClientConfiguration> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, FeignClientConfiguration> config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeignClientProperties that = (FeignClientProperties)o;
        return this.defaultToProperties == that.defaultToProperties && Objects.equals(this.defaultConfig, that.defaultConfig) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.defaultToProperties, this.defaultConfig, this.config);
    }

    public static class FeignClientConfiguration {
        private Logger.Level loggerLevel;
        private Integer connectTimeout;
        private Integer readTimeout;
        private Class<Retryer> retryer;
        private Class<ErrorDecoder> errorDecoder;
        private List<Class<RequestInterceptor>> requestInterceptors;
        private Boolean decode404;

        public Logger.Level getLoggerLevel() {
            return this.loggerLevel;
        }

        public void setLoggerLevel(Logger.Level loggerLevel) {
            this.loggerLevel = loggerLevel;
        }

        public Integer getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public Integer getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
        }

        public Class<Retryer> getRetryer() {
            return this.retryer;
        }

        public void setRetryer(Class<Retryer> retryer) {
            this.retryer = retryer;
        }

        public Class<ErrorDecoder> getErrorDecoder() {
            return this.errorDecoder;
        }

        public void setErrorDecoder(Class<ErrorDecoder> errorDecoder) {
            this.errorDecoder = errorDecoder;
        }

        public List<Class<RequestInterceptor>> getRequestInterceptors() {
            return this.requestInterceptors;
        }

        public void setRequestInterceptors(List<Class<RequestInterceptor>> requestInterceptors) {
            this.requestInterceptors = requestInterceptors;
        }

        public Boolean getDecode404() {
            return this.decode404;
        }

        public void setDecode404(Boolean decode404) {
            this.decode404 = decode404;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeignClientConfiguration that = (FeignClientConfiguration)o;
            return this.loggerLevel == that.loggerLevel && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.retryer, that.retryer) && Objects.equals(this.errorDecoder, that.errorDecoder) && Objects.equals(this.requestInterceptors, that.requestInterceptors) && Objects.equals(this.decode404, that.decode404);
        }

        public int hashCode() {
            return Objects.hash(this.loggerLevel, this.connectTimeout, this.readTimeout, this.retryer, this.errorDecoder, this.requestInterceptors, this.decode404);
        }
    }
}

