/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.encoding;

import java.util.Arrays;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="feign.compression.request")
public class FeignClientEncodingProperties {
    private String[] mimeTypes = new String[]{"text/xml", "application/xml", "application/json"};
    private int minRequestSize = 2048;

    public String[] getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(String[] mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public int getMinRequestSize() {
        return this.minRequestSize;
    }

    public void setMinRequestSize(int minRequestSize) {
        this.minRequestSize = minRequestSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeignClientEncodingProperties that = (FeignClientEncodingProperties)o;
        return Arrays.equals(this.mimeTypes, that.mimeTypes) && Objects.equals(this.minRequestSize, that.minRequestSize);
    }

    public int hashCode() {
        return Objects.hash(this.mimeTypes, this.minRequestSize);
    }

    public String toString() {
        return "FeignClientEncodingProperties{" + "mimeTypes=" + Arrays.toString(this.mimeTypes) + ", " + "minRequestSize=" + this.minRequestSize + "}";
    }
}

