/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.ribbon;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.ClientException;
import com.netflix.client.ClientRequest;
import com.netflix.client.IResponse;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.RetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cloud.netflix.ribbon.RibbonUtils;
import org.springframework.cloud.netflix.ribbon.ServerIntrospector;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;

public class FeignLoadBalancer
extends AbstractLoadBalancerAwareClient<RibbonRequest, RibbonResponse> {
    protected int connectTimeout;
    protected int readTimeout;
    protected IClientConfig clientConfig;
    protected ServerIntrospector serverIntrospector;

    public FeignLoadBalancer(ILoadBalancer lb, IClientConfig clientConfig, ServerIntrospector serverIntrospector) {
        super(lb, clientConfig);
        this.setRetryHandler(RetryHandler.DEFAULT);
        this.clientConfig = clientConfig;
        this.connectTimeout = (Integer)clientConfig.get(CommonClientConfigKey.ConnectTimeout);
        this.readTimeout = (Integer)clientConfig.get(CommonClientConfigKey.ReadTimeout);
        this.serverIntrospector = serverIntrospector;
    }

    public RibbonResponse execute(RibbonRequest request, IClientConfig configOverride) throws IOException {
        Request.Options options = configOverride != null ? new Request.Options(((Integer)configOverride.get(CommonClientConfigKey.ConnectTimeout, (Object)this.connectTimeout)).intValue(), ((Integer)configOverride.get(CommonClientConfigKey.ReadTimeout, (Object)this.readTimeout)).intValue()) : new Request.Options(this.connectTimeout, this.readTimeout);
        Response response = request.client().execute(request.toRequest(), options);
        return new RibbonResponse(request.getUri(), response);
    }

    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(RibbonRequest request, IClientConfig requestConfig) {
        if (((Boolean)this.clientConfig.get(CommonClientConfigKey.OkToRetryOnAllOperations, (Object)false)).booleanValue()) {
            return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
        }
        if (!request.toRequest().method().equals("GET")) {
            return new RequestSpecificRetryHandler(true, false, this.getRetryHandler(), requestConfig);
        }
        return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
    }

    public URI reconstructURIWithServer(Server server, URI original) {
        URI uri = RibbonUtils.updateToHttpsIfNeeded(original, this.clientConfig, this.serverIntrospector, server);
        return super.reconstructURIWithServer(server, uri);
    }

    static class RibbonResponse
    implements IResponse {
        private final URI uri;
        private final Response response;

        RibbonResponse(URI uri, Response response) {
            this.uri = uri;
            this.response = response;
        }

        public Object getPayload() throws ClientException {
            return this.response.body();
        }

        public boolean hasPayload() {
            return this.response.body() != null;
        }

        public boolean isSuccess() {
            return this.response.status() == 200;
        }

        public URI getRequestedURI() {
            return this.uri;
        }

        public Map<String, Collection<String>> getHeaders() {
            return this.response.headers();
        }

        Response toResponse() {
            return this.response;
        }

        public void close() throws IOException {
            if (this.response != null && this.response.body() != null) {
                this.response.body().close();
            }
        }
    }

    static class RibbonRequest
    extends ClientRequest
    implements Cloneable {
        private final Request request;
        private final Client client;

        RibbonRequest(Client client, Request request, URI uri) {
            this.client = client;
            this.setUri(uri);
            this.request = this.toRequest(request);
        }

        private Request toRequest(Request request) {
            LinkedHashMap headers = new LinkedHashMap(request.headers());
            return Request.create((String)request.method(), (String)this.getUri().toASCIIString(), headers, (byte[])request.body(), (Charset)request.charset());
        }

        Request toRequest() {
            return this.toRequest(this.request);
        }

        Client client() {
            return this.client;
        }

        HttpRequest toHttpRequest() {
            return new HttpRequest(){

                public HttpMethod getMethod() {
                    return HttpMethod.resolve((String)RibbonRequest.this.toRequest().method());
                }

                public URI getURI() {
                    return RibbonRequest.this.getUri();
                }

                public HttpHeaders getHeaders() {
                    HashMap headers = new HashMap();
                    Map feignHeaders = RibbonRequest.this.toRequest().headers();
                    for (String key : feignHeaders.keySet()) {
                        headers.put(key, new ArrayList((Collection)feignHeaders.get(key)));
                    }
                    HttpHeaders httpHeaders = new HttpHeaders();
                    httpHeaders.putAll(headers);
                    return httpHeaders;
                }
            };
        }

        public Object clone() {
            return new RibbonRequest(this.client, this.request, this.getUri());
        }
    }
}

