/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.SpectatorContext;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.NumericMonitor;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.monitor.SpectatorMonitor;
import com.netflix.servo.monitor.StepLong;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.util.Clock;
import com.netflix.servo.util.VisibleForTesting;
import com.netflix.spectator.api.Id;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

class DoubleCounter
extends AbstractMonitor<Number>
implements NumericMonitor<Number>,
SpectatorMonitor {
    private final MonitorConfig baseConfig;
    private final StepLong count;
    private final SpectatorContext.LazyCounter spectatorCounter;

    DoubleCounter(MonitorConfig config, Clock clock) {
        super(config.withAdditionalTag(DataSourceType.NORMALIZED));
        this.baseConfig = config;
        this.count = new StepLong(0L, clock);
        this.spectatorCounter = SpectatorContext.counter(config);
    }

    private void add(AtomicLong num, double amount) {
        double d;
        long next;
        long v;
        while (!num.compareAndSet(v = num.get(), next = Double.doubleToLongBits((d = Double.longBitsToDouble(v)) + amount))) {
        }
    }

    void increment(double amount) {
        this.spectatorCounter.add(amount);
        if (amount >= 0.0) {
            for (int i = 0; i < Pollers.NUM_POLLERS; ++i) {
                this.add(this.count.getCurrent(i), amount);
            }
        }
    }

    @Override
    public Number getValue(int pollerIndex) {
        long n = this.count.poll(pollerIndex);
        double stepSeconds = (double)Pollers.POLLING_INTERVALS[pollerIndex] / 1000.0;
        return Double.longBitsToDouble(n) / stepSeconds;
    }

    @VisibleForTesting
    public double getCurrentCount(int pollerIndex) {
        return Double.longBitsToDouble(this.count.getCurrent(pollerIndex).get());
    }

    @Override
    public void initializeSpectator(TagList tags) {
        Id id = SpectatorContext.createId(this.baseConfig.withAdditionalTags(tags));
        this.spectatorCounter.setId(id);
    }

    public String toString() {
        return "DoubleCounter{config=" + this.config + "count=" + Double.longBitsToDouble(this.count.getCurrent(0).longValue()) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleCounter that = (DoubleCounter)o;
        return this.config.equals(that.config) && Objects.equals(this.getValue(0), that.getValue(0));
    }

    public int hashCode() {
        return Objects.hash(this.config, this.getValue(0));
    }
}

