/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.contexts;

import com.netflix.server.context.BiDirectional;
import com.netflix.server.context.ContextSerializationException;
import com.netflix.server.context.ContextSerializer;
import com.netflix.server.context.DirectionAwareContextSerializer;
import io.reactivex.netty.contexts.StringSerializer;

class ContextHolder<T> {
    private T context;
    private final String contextName;
    private DirectionAwareContextSerializer<T> serializer;
    private String serialized;
    private String serializerClassName;
    private int serializedVersion;
    private String rawSerializedForm;
    private boolean updatedExternally;
    private final boolean receivedFromParent;
    private boolean biDirectional;
    private boolean isRaw;

    ContextHolder(T context, String contextName, ContextSerializer<T> serializer) {
        this.context = context;
        this.contextName = contextName;
        this.serializer = ContextHolder.unifySerializerTypes(serializer);
        this.serializerClassName = serializer.getClass().getName();
        this.biDirectional = context.getClass().getAnnotation(BiDirectional.class) != null;
        this.receivedFromParent = false;
    }

    ContextHolder(String contextName, String rawSerializedForm, boolean biDirectional) {
        this.contextName = contextName;
        this.rawSerializedForm = rawSerializedForm;
        this.biDirectional = biDirectional;
        this.receivedFromParent = true;
        this.isRaw = true;
    }

    String getRawSerializedForm() {
        return this.rawSerializedForm;
    }

    boolean hasRawSerializedForm() {
        return null != this.rawSerializedForm;
    }

    boolean isRaw() {
        return this.isRaw;
    }

    String getContextName() {
        return this.contextName;
    }

    boolean hasSerialized() {
        return null != this.serialized;
    }

    boolean hasContext() {
        return null != this.context;
    }

    String getSerialized() {
        return this.serialized;
    }

    int getSerializedVersion() {
        return this.serializedVersion;
    }

    T getContext() {
        return this.context;
    }

    boolean isUpdatedExternally() {
        return this.updatedExternally;
    }

    public boolean isReceivedFromParent() {
        return this.receivedFromParent;
    }

    public boolean shouldFlowBackInResponse() {
        return this.isBiDirectional() && (this.isUpdatedExternally() || !this.isReceivedFromParent());
    }

    void markAsUpdatedExternally() {
        this.updatedExternally = true;
    }

    boolean isBiDirectional() {
        return this.biDirectional;
    }

    DirectionAwareContextSerializer<T> getSerializer() throws ContextSerializationException {
        if (null != this.serializer) {
            return this.serializer;
        }
        if (null != this.serializerClassName) {
            if (this.serializerClassName.equals(StringSerializer.class.getName())) {
                return StringSerializer.INSTANCE;
            }
            try {
                Class<?> aClass = Class.forName(this.serializerClassName);
                this.serializer = ContextHolder.unifySerializerTypes((ContextSerializer)aClass.newInstance());
                return this.serializer;
            }
            catch (InstantiationException e) {
                throw new ContextSerializationException("Can not instantiate the serializer for class:" + this.serializerClassName, e);
            }
            catch (IllegalAccessException e) {
                throw new ContextSerializationException("Can not instantiate the serializer for class:" + this.serializerClassName, e);
            }
            catch (ClassNotFoundException e) {
                throw new ContextSerializationException("Can not instantiate the serializer for class:" + this.serializerClassName, e);
            }
            catch (ClassCastException e) {
                throw new ContextSerializationException("Serializer:" + this.serializerClassName + " is not of the required type.", e);
            }
        }
        throw new ContextSerializationException("No serializer found.");
    }

    ContextSerializer<T> getRawSerializer() throws ContextSerializationException {
        DirectionAwareContextSerializer<T> serializer = this.getSerializer();
        if (DirectionalSerializerAdapter.class.isAssignableFrom(serializer.getClass())) {
            return ((DirectionalSerializerAdapter)serializer).actualSerializer;
        }
        return serializer;
    }

    static <T> DirectionAwareContextSerializer<T> unifySerializerTypes(ContextSerializer<T> serializer) {
        return DirectionAwareContextSerializer.class.isAssignableFrom(serializer.getClass()) ? (DirectionAwareContextSerializer)serializer : new DirectionalSerializerAdapter(serializer);
    }

    String getSerializerClassName() {
        if (null == this.serializerClassName && null != this.serializer && this.serializer.getClass().equals(DirectionalSerializerAdapter.class)) {
            return ((DirectionalSerializerAdapter)this.serializer).actualSerializer.getClass().getName();
        }
        return this.serializerClassName;
    }

    void update(String serialized, int serializedVersion, String serializerClassName) {
        this.serialized = serialized;
        this.serializedVersion = serializedVersion;
        this.serializerClassName = serializerClassName;
        this.isRaw = false;
    }

    void update(T context) {
        this.context = context;
        this.biDirectional = context.getClass().getAnnotation(BiDirectional.class) != null;
    }

    private static class DirectionalSerializerAdapter<T>
    implements DirectionAwareContextSerializer<T> {
        private final ContextSerializer<T> actualSerializer;

        private DirectionalSerializerAdapter(ContextSerializer<T> actualSerializer) {
            this.actualSerializer = actualSerializer;
        }

        @Override
        public String serialize(T toSerialize, DirectionAwareContextSerializer.Direction direction) throws ContextSerializationException {
            return this.actualSerializer.serialize(toSerialize);
        }

        @Override
        public T deserialize(String serialized, DirectionAwareContextSerializer.Direction direction, int version) throws ContextSerializationException {
            return this.actualSerializer.deserialize(serialized, version);
        }

        @Override
        public int getVersion() {
            return this.actualSerializer.getVersion();
        }

        @Override
        public String serialize(T toSerialize) throws ContextSerializationException {
            return this.actualSerializer.serialize(toSerialize);
        }

        @Override
        public T deserialize(String serialized, int version) throws ContextSerializationException {
            return this.actualSerializer.deserialize(serialized, version);
        }
    }
}

