/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.cache;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstanceStatus;
import org.apache.servicecomb.serviceregistry.cache.CacheEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceCache.class);
    private static final AtomicInteger VERSION = new AtomicInteger();
    private int cacheVersion;
    private String appId;
    private String microserviceName;
    private String microserviceVersionRule;
    private Map<String, MicroserviceInstance> instanceMap;
    private VersionedCache versionedCache;
    private volatile Map<String, List<CacheEndpoint>> transportMap;
    private Object lockObj = new Object();

    public InstanceCache(String appId, String microserviceName, String microserviceVersionRule, Map<String, MicroserviceInstance> instanceMap) {
        this.cacheVersion = VERSION.getAndIncrement();
        this.appId = appId;
        this.microserviceName = microserviceName;
        this.microserviceVersionRule = microserviceVersionRule;
        this.instanceMap = instanceMap;
        this.versionedCache = new VersionedCache().name(microserviceVersionRule).autoCacheVersion().data(instanceMap);
    }

    public VersionedCache getVersionedCache() {
        return this.versionedCache;
    }

    public boolean cacheChanged(InstanceCache newCache) {
        return newCache != null && newCache.instanceMap != null && newCache.cacheVersion != this.cacheVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<CacheEndpoint>> getOrCreateTransportMap() {
        if (this.transportMap == null) {
            Object object = this.lockObj;
            synchronized (object) {
                if (this.transportMap == null) {
                    this.transportMap = this.createTransportMap();
                }
            }
        }
        return this.transportMap;
    }

    protected Map<String, List<CacheEndpoint>> createTransportMap() {
        HashMap<String, List<CacheEndpoint>> transportMap = new HashMap<String, List<CacheEndpoint>>();
        for (MicroserviceInstance instance : this.instanceMap.values()) {
            if (instance.getStatus() != MicroserviceInstanceStatus.UP) continue;
            for (String endpoint : instance.getEndpoints()) {
                try {
                    URI uri = URI.create(endpoint);
                    String transportName = uri.getScheme();
                    List cacheEndpointList = transportMap.computeIfAbsent(transportName, k -> new ArrayList());
                    cacheEndpointList.add(new CacheEndpoint(endpoint, instance));
                }
                catch (Exception e) {
                    LOGGER.warn("unrecognized address find, ignore " + endpoint);
                }
            }
        }
        return transportMap;
    }

    public Map<String, MicroserviceInstance> getInstanceMap() {
        return this.instanceMap;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public String getMicroserviceVersionRule() {
        return this.microserviceVersionRule;
    }

    public String getAppId() {
        return this.appId;
    }
}

