/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.runtime.FieldMapEx;
import io.protostuff.runtime.FieldSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HashFieldMapEx<T>
implements FieldMapEx<T> {
    private final List<FieldSchema<T>> fields;
    private final Map<Integer, FieldSchema<T>> fieldsByNumber;
    private final Map<String, FieldSchema<T>> fieldsByName = new HashMap<String, FieldSchema<T>>();

    public HashFieldMapEx(Collection<FieldSchema<T>> fields) {
        this.fieldsByNumber = new HashMap<Integer, FieldSchema<T>>();
        for (FieldSchema<T> f : fields) {
            if (this.fieldsByName.containsKey(f.name)) {
                FieldSchema<T> prev = this.fieldsByName.get(f.name);
                throw new IllegalStateException(prev + " and " + f + " cannot have the same name.");
            }
            if (this.fieldsByNumber.containsKey(f.fieldNumber)) {
                FieldSchema<T> prev = this.fieldsByNumber.get(f.fieldNumber);
                throw new IllegalStateException(prev + " and " + f + " cannot have the same number.");
            }
            this.fieldsByNumber.put(f.fieldNumber, f);
            this.fieldsByName.put(f.name, f);
        }
        ArrayList<FieldSchema<T>> fieldList = new ArrayList<FieldSchema<T>>(fields.size());
        fieldList.addAll(fields);
        Collections.sort(fieldList, Comparator.comparingInt(FieldSchema::getFieldNumber));
        this.fields = Collections.unmodifiableList(fieldList);
    }

    @Override
    public FieldSchema<T> getFieldByNumber(int n) {
        return this.fieldsByNumber.get(n);
    }

    @Override
    public FieldSchema<T> getFieldByName(String fieldName) {
        return this.fieldsByName.get(fieldName);
    }

    @Override
    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public List<FieldSchema<T>> getFields() {
        return this.fields;
    }
}

