/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.scalar;

import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.FloatGetter;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class FloatWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        if (Float.TYPE.equals(propertyDescriptor.getJavaType().getRawClass())) {
            return new FloatPrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Float.class.equals((Object)propertyDescriptor.getJavaType().getRawClass())) {
            return new FloatSchema(protoField, propertyDescriptor);
        }
        return new FloatDynamicSchema(protoField, propertyDescriptor);
    }

    private static class FloatPrimitiveSchema<T>
    extends FloatDynamicSchema<T> {
        private final FloatGetter<T> primitiveGetter;

        public FloatPrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.primitiveGetter = (FloatGetter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            float value = this.primitiveGetter.get(message);
            output.writeScalarFloat(this.tag, this.tagSize, value);
        }
    }

    private static class FloatSchema<T>
    extends FloatDynamicSchema<T> {
        protected final Getter<T, Float> getter;

        public FloatSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.getter = this.javaType.isPrimitive() ? null : (Getter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            Float value = (Float)this.getter.get(message);
            if (value != null) {
                output.writeScalarFloat(this.tag, this.tagSize, value.floatValue());
            }
        }
    }

    private static class FloatDynamicSchema<T>
    extends FieldSchema<T> {
        public FloatDynamicSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
        }

        @Override
        public final void writeTo(OutputEx output, Object value) throws IOException {
            if (value instanceof Number) {
                output.writeScalarFloat(this.tag, this.tagSize, ((Number)value).floatValue());
                return;
            }
            if (value instanceof String[]) {
                if (((String[])value).length == 0) {
                    return;
                }
                float parsedValue = Float.parseFloat(((String[])value)[0]);
                output.writeScalarFloat(this.tag, this.tagSize, parsedValue);
                return;
            }
            if (value instanceof String) {
                float parsedValue = Float.parseFloat((String)value);
                output.writeScalarFloat(this.tag, this.tagSize, parsedValue);
                return;
            }
            ProtoUtils.throwNotSupportWrite(this.protoField, value);
        }
    }
}

