/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.scalar;

import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class StringWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        if (String.class.equals((Object)propertyDescriptor.getJavaType().getRawClass())) {
            return new StringSchema(protoField, propertyDescriptor);
        }
        return new StringDynamicSchema(protoField, propertyDescriptor);
    }

    private static class StringSchema<T>
    extends StringDynamicSchema<T> {
        protected final Getter<T, String> getter;

        public StringSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.getter = this.javaType.isPrimitive() ? null : (Getter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            String value = (String)this.getter.get(message);
            if (value != null) {
                output.writeScalarString(this.tag, this.tagSize, value);
            }
        }
    }

    private static class StringDynamicSchema<T>
    extends FieldSchema<T> {
        public StringDynamicSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
        }

        @Override
        public final void writeTo(OutputEx output, Object value) throws IOException {
            if (value instanceof String) {
                output.writeScalarString(this.tag, this.tagSize, (String)value);
                return;
            }
            if (value instanceof String[]) {
                if (((String[])value).length == 0) {
                    return;
                }
                output.writeScalarString(this.tag, this.tagSize, ((String[])value)[0]);
                return;
            }
            ProtoUtils.throwNotSupportWrite(this.protoField, value);
        }
    }
}

