/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.Collection;
import java.util.Collections;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.result.condition.AbstractRequestCondition;
import org.springframework.web.reactive.result.condition.RequestCondition;
import org.springframework.web.server.ServerWebExchange;

public final class RequestConditionHolder
extends AbstractRequestCondition<RequestConditionHolder> {
    @Nullable
    private final RequestCondition<Object> condition;

    public RequestConditionHolder(@Nullable RequestCondition<?> requestCondition) {
        this.condition = requestCondition;
    }

    @Nullable
    public RequestCondition<?> getCondition() {
        return this.condition;
    }

    @Override
    protected Collection<?> getContent() {
        return this.condition != null ? Collections.singleton(this.condition) : Collections.emptyList();
    }

    @Override
    protected String getToStringInfix() {
        return " ";
    }

    @Override
    public RequestConditionHolder combine(RequestConditionHolder other) {
        if (this.condition == null && other.condition == null) {
            return this;
        }
        if (this.condition == null) {
            return other;
        }
        if (other.condition == null) {
            return this;
        }
        this.assertEqualConditionTypes(this.condition, other.condition);
        RequestCondition<Object> combined = this.condition.combine(other.condition);
        return new RequestConditionHolder(combined);
    }

    @Override
    public RequestConditionHolder getMatchingCondition(ServerWebExchange exchange) {
        if (this.condition == null) {
            return this;
        }
        RequestCondition match = (RequestCondition)this.condition.getMatchingCondition(exchange);
        return match != null ? new RequestConditionHolder(match) : null;
    }

    @Override
    public int compareTo(RequestConditionHolder other, ServerWebExchange exchange) {
        if (this.condition == null && other.condition == null) {
            return 0;
        }
        if (this.condition == null) {
            return 1;
        }
        if (other.condition == null) {
            return -1;
        }
        this.assertEqualConditionTypes(this.condition, other.condition);
        return this.condition.compareTo(other.condition, exchange);
    }

    private void assertEqualConditionTypes(RequestCondition<?> cond1, RequestCondition<?> cond2) {
        Class<?> otherClazz;
        Class<?> clazz = cond1.getClass();
        if (!clazz.equals(otherClazz = cond2.getClass())) {
            throw new ClassCastException("Incompatible request conditions: " + clazz + " vs " + otherClazz);
        }
    }
}

