/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.annotation;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import io.swagger.annotations.ResponseHeader;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.utils.PropertyModelConverter;
import io.swagger.util.ParameterProcessor;
import io.swagger.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.models.ResponseConfig;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.models.ResponseConfigBase;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.models.ResponseHeaderConfig;
import org.springframework.util.ClassUtils;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static void appendDefinition(Swagger swagger, Map<String, Model> newDefinitions) {
        if (newDefinitions.isEmpty()) {
            return;
        }
        LinkedHashMap<String, Model> definitions = swagger.getDefinitions();
        if (definitions == null) {
            definitions = new LinkedHashMap<String, Model>();
            swagger.setDefinitions(definitions);
        }
        definitions.putAll(newDefinitions);
    }

    private static ResponseConfig convert(ApiOperation apiOperation) {
        ResponseConfig responseConfig = new ResponseConfig();
        responseConfig.setCode(apiOperation.code());
        responseConfig.setResponseClass(apiOperation.response());
        responseConfig.setResponseContainer(apiOperation.responseContainer());
        responseConfig.setResponseReference(apiOperation.responseReference());
        responseConfig.setResponseHeaders(apiOperation.responseHeaders());
        return responseConfig;
    }

    private static ResponseConfig convert(ApiResponse apiResponse) {
        ResponseConfig responseConfig = new ResponseConfig();
        responseConfig.setCode(apiResponse.code());
        responseConfig.setDescription(apiResponse.message());
        responseConfig.setResponseClass(apiResponse.response());
        responseConfig.setResponseContainer(apiResponse.responseContainer());
        responseConfig.setResponseReference(apiResponse.reference());
        responseConfig.setResponseHeaders(apiResponse.responseHeaders());
        return responseConfig;
    }

    public static ResponseHeaderConfig convert(ResponseHeader responseHeader) {
        if (StringUtils.isEmpty((CharSequence)responseHeader.name())) {
            return null;
        }
        ResponseHeaderConfig config = new ResponseHeaderConfig();
        config.setName(responseHeader.name());
        config.setDescription(responseHeader.description());
        config.setResponseClass(responseHeader.response());
        config.setResponseContainer(responseHeader.responseContainer());
        return config;
    }

    public static void addResponse(Swagger swagger, Operation operation, ApiOperation apiOperation) {
        ResponseConfig responseConfig = AnnotationUtils.convert(apiOperation);
        AnnotationUtils.generateResponse(swagger, responseConfig);
        AnnotationUtils.mergeResponse(operation, responseConfig);
    }

    public static void addResponse(Swagger swagger, ApiResponse apiResponse) {
        ResponseConfig responseConfig = AnnotationUtils.convert(apiResponse);
        AnnotationUtils.generateResponse(swagger, responseConfig);
        swagger.response(String.valueOf(responseConfig.getCode()), responseConfig.getResponse());
    }

    public static void addResponse(Swagger swagger, Operation operation, ApiResponse apiResponse) {
        ResponseConfig responseConfig = AnnotationUtils.convert(apiResponse);
        AnnotationUtils.generateResponse(swagger, responseConfig);
        AnnotationUtils.mergeResponse(operation, responseConfig);
    }

    private static void mergeResponse(Operation operation, ResponseConfig responseConfig) {
        if (operation.getResponses() == null) {
            operation.response(responseConfig.getCode(), responseConfig.getResponse());
            return;
        }
        Response response = (Response)operation.getResponses().get(String.valueOf(responseConfig.getCode()));
        if (response == null) {
            operation.response(responseConfig.getCode(), responseConfig.getResponse());
            return;
        }
        Response sourceResp = responseConfig.getResponse();
        if (StringUtils.isNotEmpty((CharSequence)sourceResp.getDescription()) && StringUtils.isEmpty((CharSequence)response.getDescription())) {
            response.setDescription(sourceResp.getDescription());
        }
        if (sourceResp.getResponseSchema() != null && response.getResponseSchema() == null) {
            response.setResponseSchema(sourceResp.getResponseSchema());
        }
        if (sourceResp.getExamples() != null && response.getExamples() == null) {
            response.setExamples(sourceResp.getExamples());
        }
        if (sourceResp.getHeaders() != null && response.getHeaders() == null) {
            response.setHeaders(sourceResp.getHeaders());
        }
        if (sourceResp.getVendorExtensions() != null && response.getVendorExtensions() == null) {
            response.setVendorExtensions(sourceResp.getVendorExtensions());
        }
    }

    private static void generateResponse(Swagger swagger, ResponseConfig responseConfig) {
        Response response = new Response();
        Property property = AnnotationUtils.generateResponseProperty(swagger, responseConfig);
        if (property != null) {
            Model model = new PropertyModelConverter().propertyToModel(property);
            response.setResponseSchema(model);
        }
        response.setDescription(responseConfig.getDescription());
        if (responseConfig.getResponseHeaders() != null) {
            Map<String, Property> headers = AnnotationUtils.generateResponseHeader(swagger, responseConfig.getResponseHeaders());
            response.setHeaders(headers);
        }
        responseConfig.setResponse(response);
    }

    private static Map<String, Property> generateResponseHeader(Swagger swagger, List<ResponseHeaderConfig> responseHeaders) {
        HashMap<String, Property> headers = new HashMap<String, Property>();
        for (ResponseHeaderConfig config : responseHeaders) {
            Property property = AnnotationUtils.generateResponseHeaderProperty(swagger, config);
            headers.put(config.getName(), property);
        }
        return headers;
    }

    public static Property generateResponseHeaderProperty(Swagger swagger, ResponseHeaderConfig config) throws Error {
        Property property = AnnotationUtils.generateResponseProperty(swagger, config);
        if (property == null) {
            throw new Error("invalid responseHeader, " + config);
        }
        return property;
    }

    public static Property generateResponseProperty(Swagger swagger, ResponseConfigBase config) throws Error {
        Class<?> responseClass = config.getResponseClass();
        if (responseClass == null || ReflectionUtils.isVoid(responseClass)) {
            return null;
        }
        if (!ClassUtils.isPrimitiveOrWrapper(responseClass)) {
            Map newDefinitions = ModelConverters.getInstance().readAll(responseClass);
            AnnotationUtils.appendDefinition(swagger, newDefinitions);
        }
        Property property = ModelConverters.getInstance().readAsProperty(responseClass);
        switch (config.getResponseContainer()) {
            case "List": {
                property = new ArrayProperty(property);
                break;
            }
            case "Set": {
                property = new ArrayProperty(property);
                ((ArrayProperty)property).setUniqueItems(Boolean.valueOf(true));
                break;
            }
            case "Map": {
                property = new MapProperty(property);
                break;
            }
            case "": {
                break;
            }
            default: {
                throw new Error("not support responseContainer " + config.getResponseContainer());
            }
        }
        return property;
    }

    public static Parameter createParameter(Swagger swagger, ApiImplicitParam paramAnnotation) {
        Parameter parameter = AnnotationUtils.createParameterInstance(paramAnnotation);
        Type dataType = ReflectionUtils.typeFromString((String)paramAnnotation.dataType());
        parameter = ParameterProcessor.applyAnnotations((Swagger)swagger, (Parameter)parameter, (Type)dataType, Arrays.asList(paramAnnotation));
        return parameter;
    }

    private static Parameter createParameterInstance(ApiImplicitParam paramAnnotation) {
        switch (paramAnnotation.paramType()) {
            case "path": {
                return new PathParameter();
            }
            case "query": {
                return new QueryParameter();
            }
            case "body": {
                return new BodyParameter();
            }
            case "header": {
                return new HeaderParameter();
            }
            case "form": {
                return new FormParameter();
            }
            case "cookie": {
                return new CookieParameter();
            }
        }
        throw new Error("not support paramType " + paramAnnotation.paramType());
    }

    public static <T> T findAnnotation(Annotation[] annotations, Class<T> annotationType) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (T)annotation;
        }
        return null;
    }

    public static void processApiParam(Annotation[] paramAnnotations, Parameter parameter) {
        ApiParam param = AnnotationUtils.findAnnotation(paramAnnotations, ApiParam.class);
        if (param == null) {
            return;
        }
        if (parameter instanceof AbstractSerializableParameter) {
            AnnotationUtils.processApiParam(param, (AbstractSerializableParameter)parameter);
            return;
        }
        AnnotationUtils.processApiParam(param, (BodyParameter)parameter);
    }

    protected static void processApiParam(ApiParam param, BodyParameter p) {
        Example example;
        if (param.required()) {
            p.setRequired(true);
        }
        if (StringUtils.isNotEmpty((CharSequence)param.name())) {
            p.setName(param.name());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.value())) {
            p.setDescription(param.value());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.access())) {
            p.setAccess(param.access());
        }
        if ((example = param.examples()) != null && example.value() != null) {
            for (ExampleProperty ex : example.value()) {
                String mediaType = ex.mediaType();
                String value = ex.value();
                if (mediaType.isEmpty() || value.isEmpty()) continue;
                p.example(mediaType.trim(), value.trim());
            }
        }
    }

    protected static void processApiParam(ApiParam param, AbstractSerializableParameter<?> p) {
        if (param.required()) {
            p.setRequired(true);
        }
        if (param.readOnly()) {
            p.setReadOnly(Boolean.valueOf(true));
        }
        if (param.allowEmptyValue()) {
            p.setAllowEmptyValue(Boolean.valueOf(true));
        }
        if (StringUtils.isNotEmpty((CharSequence)param.name())) {
            p.setName(param.name());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.value())) {
            p.setDescription(param.value());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.example())) {
            p.setExample(param.example());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.access())) {
            p.setAccess(param.access());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{param.collectionFormat()})) {
            p.setCollectionFormat(param.collectionFormat());
        }
        if (StringUtils.isNotEmpty((CharSequence)param.type())) {
            if ("java.io.File".equalsIgnoreCase(param.type())) {
                p.setProperty((Property)new FileProperty());
            } else if ("long".equalsIgnoreCase(param.type())) {
                p.setProperty((Property)new LongProperty());
            } else {
                p.setType(param.type());
            }
        }
    }
}

