/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.util.concurrent;

import java.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownEnabledTimer
extends Timer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownEnabledTimer.class);
    private Thread cancelThread;
    private String name;

    public ShutdownEnabledTimer(String name, boolean daemon) {
        super(name, daemon);
        this.name = name;
        this.cancelThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ShutdownEnabledTimer.super.cancel();
            }
        });
        LOGGER.info("Shutdown hook installed for: {}", (Object)this.name);
        Runtime.getRuntime().addShutdownHook(this.cancelThread);
    }

    @Override
    public void cancel() {
        super.cancel();
        LOGGER.info("Shutdown hook removed for: {}", (Object)this.name);
        try {
            Runtime.getRuntime().removeShutdownHook(this.cancelThread);
        }
        catch (IllegalStateException ise) {
            LOGGER.info("Exception caught (might be ok if at shutdown)", (Throwable)ise);
        }
    }
}

