/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class PlatformDependent {
    public static final int ANDROID_API_VERSION_IS_NOT_ANDROID = 0;
    private static final int ANDROID_API_VERSION = PlatformDependent.resolveAndroidApiVersion();
    private static final boolean IS_ANDROID = ANDROID_API_VERSION != 0;

    public static boolean isAndroid() {
        return IS_ANDROID;
    }

    public static int getAndroidApiVersion() {
        return ANDROID_API_VERSION;
    }

    private static int resolveAndroidApiVersion() {
        try {
            return (Integer)Class.forName("android.os.Build$VERSION", true, PlatformDependent.getSystemClassLoader()).getField("SDK_INT").get(null);
        }
        catch (Exception e) {
            return 0;
        }
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }
}

