/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerStats;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.loadbalance.LoadBalancer;
import org.apache.servicecomb.loadbalance.RoundRobinRuleExt;
import org.apache.servicecomb.loadbalance.ServiceCombServer;

public class WeightedResponseTimeRuleExt
extends RoundRobinRuleExt {
    private static final double MIN_GAP = 10.0;
    private static final int RANDOM_PERCENT = 10;
    private LoadBalancer loadBalancer;
    private double totalWeightsCache = -1.0;

    @Override
    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    @Override
    public ServiceCombServer choose(List<ServiceCombServer> servers, Invocation invocation) {
        List<Double> stats = this.calculateTotalWeights(servers);
        if (stats.size() > 0) {
            double finalTotal = stats.get(stats.size() - 1);
            ArrayList<Double> weights = new ArrayList<Double>(servers.size());
            for (int i = 0; i < stats.size() - 1; ++i) {
                weights.add(finalTotal - stats.get(i));
            }
            double ran = ThreadLocalRandom.current().nextDouble() * finalTotal * (double)(servers.size() - 1);
            for (int i = 0; i < weights.size(); ++i) {
                if (!((ran -= ((Double)weights.get(i)).doubleValue()) < 0.0)) continue;
                return servers.get(i);
            }
            return servers.get(servers.size() - 1);
        }
        return super.choose(servers, invocation);
    }

    private List<Double> calculateTotalWeights(List<ServiceCombServer> servers) {
        if (Double.compare(this.totalWeightsCache, 0.0) < 0 || Double.compare(this.totalWeightsCache, 10.0 * (double)servers.size()) > 0) {
            return this.doCalculateTotalWeights(servers);
        }
        if (ThreadLocalRandom.current().nextInt(10) == 0) {
            return this.doCalculateTotalWeights(servers);
        }
        return new ArrayList<Double>();
    }

    private List<Double> doCalculateTotalWeights(List<ServiceCombServer> servers) {
        ArrayList<Double> stats = new ArrayList<Double>(servers.size() + 1);
        double totalWeights = 0.0;
        boolean needRandom = false;
        for (ServiceCombServer server : servers) {
            ServerStats serverStats = this.loadBalancer.getLoadBalancerStats().getSingleServerStat((Server)server);
            double avgTime = serverStats.getResponseTimeAvgRecent();
            if (!needRandom && avgTime > 10.0) {
                needRandom = true;
            }
            totalWeights += avgTime;
            stats.add(avgTime);
        }
        stats.add(totalWeights);
        this.totalWeightsCache = totalWeights;
        if (needRandom) {
            return stats;
        }
        return new ArrayList<Double>();
    }
}

