/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gpx;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.storage.gpx.Email;
import org.apache.sis.storage.gpx.Link;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.citation.Telephone;
import org.opengis.util.InternationalString;

public final class Person
implements ResponsibleParty,
Contact,
Address {
    @XmlElement(name="name")
    public String name;
    boolean isCreator;
    @XmlElement(name="email")
    @XmlJavaTypeAdapter(value=Email.class)
    public String email;
    @XmlElement(name="link")
    public Link link;

    public Person() {
    }

    Person(String creator) {
        this.name = creator;
        this.isCreator = true;
    }

    public static Person castOrCopy(ResponsibleParty r, Locale locale) {
        String name;
        boolean isCreator;
        if (r == null || r instanceof Person) {
            return (Person)r;
        }
        Role role = r.getRole();
        boolean bl = isCreator = role == Role.ORIGINATOR;
        if ((isCreator || Role.AUTHOR.equals((Object)role)) && (name = r.getIndividualName()) != null) {
            Person pr = new Person();
            pr.name = name;
            pr.isCreator = isCreator;
            return pr;
        }
        return null;
    }

    public Role getRole() {
        return this.isCreator ? Role.ORIGINATOR : Role.AUTHOR;
    }

    public InternationalString getOrganisationName() {
        return null;
    }

    public InternationalString getPositionName() {
        return null;
    }

    public String getIndividualName() {
        return this.name;
    }

    public Contact getContactInfo() {
        return this.email != null || this.link != null ? this : null;
    }

    public Telephone getPhone() {
        return null;
    }

    public Address getAddress() {
        return this.email != null ? this : null;
    }

    public OnlineResource getOnlineResource() {
        return this.link;
    }

    public InternationalString getHoursOfService() {
        return null;
    }

    public InternationalString getContactInstructions() {
        return null;
    }

    public Collection<String> getDeliveryPoints() {
        return Collections.emptyList();
    }

    public InternationalString getCity() {
        return null;
    }

    public InternationalString getAdministrativeArea() {
        return null;
    }

    public String getPostalCode() {
        return null;
    }

    public InternationalString getCountry() {
        return null;
    }

    public Collection<String> getElectronicMailAddresses() {
        return this.email != null ? Collections.singleton(this.email) : Collections.emptySet();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Person) {
            Person that = (Person)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.email, that.email) && Objects.equals(this.link, that.link);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.email, this.link);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name);
        }
        if (this.email != null) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append('<').append(this.email).append('>');
        }
        if (this.link != null) {
            if (sb.length() != 0) {
                sb.append(System.lineSeparator());
            }
            sb.append(this.link);
        }
        return sb.toString();
    }
}

