/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Objects;
import java.util.Optional;
import javax.measure.Unit;
import org.apache.sis.filter.Expression;
import org.apache.sis.measure.Units;
import org.apache.sis.style.se1.Description;
import org.apache.sis.style.se1.LineSymbolizer;
import org.apache.sis.style.se1.PointSymbolizer;
import org.apache.sis.style.se1.PolygonSymbolizer;
import org.apache.sis.style.se1.RasterSymbolizer;
import org.apache.sis.style.se1.StyleElement;
import org.apache.sis.style.se1.StyleFactory;
import org.apache.sis.style.se1.TextSymbolizer;
import org.apache.sis.util.resources.Errors;

@XmlType(name="SymbolizerType", propOrder={"name", "description", "geometry"})
@XmlSeeAlso(value={LineSymbolizer.class, PointSymbolizer.class, PolygonSymbolizer.class, TextSymbolizer.class, RasterSymbolizer.class})
@XmlRootElement(name="Symbolizer")
public abstract class Symbolizer<R>
extends StyleElement<R> {
    @XmlElement(name="Name")
    protected String name;
    @XmlElement(name="Description")
    protected Description<R> description;
    @XmlElement(name="Geometry")
    protected Expression<R, ?> geometry;
    @XmlAttribute(name="uom")
    @XmlSchemaType(name="anyURI")
    protected Unit<?> unit;

    Symbolizer() {
    }

    public Symbolizer(StyleFactory<R> factory) {
        super(factory);
    }

    protected Symbolizer(Symbolizer<R> source) {
        super(source);
        this.name = source.name;
        this.geometry = source.geometry;
        this.description = source.description;
        this.unit = source.unit;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public void setName(String value) {
        this.name = value;
    }

    public Optional<Description<R>> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public void setDescription(Description<R> value) {
        this.description = value;
    }

    public Unit<?> getUnitOfMeasure() {
        Unit value = this.unit;
        return value != null ? value : Units.PIXEL;
    }

    public void setUnitOfMeasure(Unit<?> value) {
        if (value != null && value != Units.PIXEL && !Units.isLinear(value)) {
            throw new IllegalArgumentException(Errors.format((short)130, value));
        }
        this.unit = value;
    }

    public Expression<R, ?> getGeometry() {
        Expression<R, ?> value = this.geometry;
        return value != null ? value : this.factory.defaultGeometry;
    }

    public void setGeometry(Expression<R, ?> value) {
        this.geometry = value;
    }

    public boolean isVisible() {
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.name, this.description, this.geometry, this.unit);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Symbolizer other = (Symbolizer)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.geometry, other.geometry) && Objects.equals(this.unit, other.unit);
    }

    @Override
    public Symbolizer<R> clone() {
        Symbolizer clone = (Symbolizer)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.description != null) {
            this.description = this.description.clone();
        }
    }
}

