/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.util.internal.shared.AbstractMapEntry;
import org.apache.sis.util.resources.Errors;

abstract class PropertyMap<V>
extends AbstractMap<String, V> {
    final PropertyAccessor accessor;
    protected final KeyNamePolicy keyPolicy;
    private transient Set<Map.Entry<String, V>> entrySet;

    PropertyMap(PropertyAccessor accessor, KeyNamePolicy keyPolicy) {
        this.accessor = accessor;
        this.keyPolicy = keyPolicy;
    }

    @Override
    public int size() {
        return this.accessor.count();
    }

    boolean contains(int index) {
        return index >= 0;
    }

    abstract V getReflectively(int var1);

    V setReflectively(int index, V value) {
        throw new UnsupportedOperationException(Errors.format((short)185, Map.class));
    }

    @Override
    public final boolean containsKey(Object key) {
        return key instanceof String && this.contains(this.accessor.indexOf((String)key, false));
    }

    @Override
    public final V get(Object key) {
        if (key instanceof String) {
            return this.getReflectively(this.accessor.indexOf((String)key, false));
        }
        return null;
    }

    @Override
    public final V put(String key, V value) {
        return this.setReflectively(this.accessor.indexOf(key, true), value);
    }

    @Override
    public final V remove(Object key) throws UnsupportedOperationException {
        if (key instanceof String) {
            return this.setReflectively(this.accessor.indexOf((String)key, false), null);
        }
        return null;
    }

    @Override
    public final Set<Map.Entry<String, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new Entries();
        }
        return this.entrySet;
    }

    Iterator<Map.Entry<String, V>> iterator() {
        return new Iterator<Map.Entry<String, V>>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < PropertyMap.this.accessor.count();
            }

            @Override
            public Map.Entry<String, V> next() {
                int i;
                String name;
                if ((name = PropertyMap.this.accessor.name(i = this.index++, PropertyMap.this.keyPolicy)) != null) {
                    return new AbstractMap.SimpleImmutableEntry(name, PropertyMap.this.getReflectively(i));
                }
                throw new NoSuchElementException();
            }
        };
    }

    private final class Entries
    extends AbstractSet<Map.Entry<String, V>> {
        Entries() {
        }

        @Override
        public final boolean isEmpty() {
            return PropertyMap.this.isEmpty();
        }

        @Override
        public final int size() {
            return PropertyMap.this.size();
        }

        @Override
        public final Iterator<Map.Entry<String, V>> iterator() {
            return PropertyMap.this.iterator();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (value != null) {
                    return value.equals(PropertyMap.this.get(key));
                }
                return PropertyMap.this.containsKey(key);
            }
            return false;
        }
    }

    private final class ReflectiveEntry
    extends AbstractMapEntry<String, V> {
        final int index;

        ReflectiveEntry(int index) {
            this.index = index;
        }

        public String getKey() {
            return PropertyMap.this.accessor.name(this.index, PropertyMap.this.keyPolicy);
        }

        public V getValue() {
            return PropertyMap.this.getReflectively(this.index);
        }

        public V setValue(V value) {
            return PropertyMap.this.setReflectively(this.index, value);
        }
    }

    final class ReflectiveIterator
    implements Iterator<Map.Entry<String, V>> {
        private ReflectiveEntry current;
        private ReflectiveEntry next;

        ReflectiveIterator() {
            this.move(0);
        }

        private void move(int index) {
            int count = PropertyMap.this.accessor.count();
            while (index < count) {
                if (PropertyMap.this.contains(index)) {
                    this.next = new ReflectiveEntry(index);
                    return;
                }
                ++index;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<String, V> next() {
            if (this.next != null) {
                this.current = this.next;
                this.move(this.next.index + 1);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.setValue(null);
            this.current = null;
        }
    }
}

