/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.scanner.impl.fwk;

import java.io.FileReader;
import java.io.FileWriter;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class FrameworkPropertiesGatherer {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.print("usage: FrameworkPropertiesGatherer <in props filename> <out props filename>");
            System.exit(1);
        }
        Properties inProps = new Properties();
        try (FileReader reader = new FileReader(args[0]);){
            inProps.load(reader);
        }
        ServiceLoader<FrameworkFactory> ldr = ServiceLoader.load(FrameworkFactory.class);
        FrameworkFactory ff = ldr.iterator().next();
        Framework fwk = ff.newFramework((Map)inProps);
        fwk.init();
        fwk.start();
        Dictionary headers = fwk.getHeaders();
        Properties outProps = new Properties();
        outProps.put("org.osgi.framework.system.packages", headers.get("Export-Package"));
        outProps.put("org.osgi.framework.system.capabilities", headers.get("Provide-Capability"));
        fwk.stop();
        try (FileWriter writer = new FileWriter(args[1]);){
            outProps.store(writer, "Framework exports and capabilities");
        }
        fwk.waitForStop(1000L);
        System.exit(0);
    }
}

