/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Map;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.ServicePropertiesMap;
import org.apache.sling.models.impl.injectors.SlingObjectInjector;
import org.apache.sling.models.testutil.ModelAdapterFactoryUtil;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.testing.mock.osgi.junit.OsgiContext;
import org.apache.sling.testing.mock.osgi.junit5.OsgiContextExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={OsgiContextExtension.class, MockitoExtension.class})
class StaticInjectionAPFLoadOrderTest {
    final OsgiContext context = new OsgiContext();
    @Mock
    private SlingJakartaHttpServletRequest request;
    @Mock
    private ResourceResolver resourceResolver;
    @Mock
    private BindingsValuesProvidersByContext bindingsValuesProvidersByContext;
    @Mock
    private AdapterManager adapterManager;
    private ModelAdapterFactory factory;

    StaticInjectionAPFLoadOrderTest() {
    }

    @BeforeEach
    void setUp() {
        this.registerServices();
    }

    @Test
    void testFactory_Injector_Model() {
        Mockito.when((Object)this.request.getResourceResolver()).thenReturn(null);
        this.registerCustomInjector();
        this.registerModel();
        Assertions.assertFalse((boolean)this.createModel().hasResourceResolver());
    }

    @Test
    void testFactory_Injector_Model_WithResourceResolver() {
        Mockito.when((Object)this.request.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        this.registerCustomInjector();
        this.registerModel();
        Assertions.assertTrue((boolean)this.createModel().hasResourceResolver());
    }

    @Test
    void testFactory_Model_Injector() {
        Mockito.when((Object)this.request.getResourceResolver()).thenReturn(null);
        this.registerModel();
        this.registerCustomInjector();
        Assertions.assertFalse((boolean)this.createModel().hasResourceResolver());
    }

    @Test
    void testFactory_Model_Injector_WithResourceResolver() {
        Mockito.when((Object)this.request.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        this.registerModel();
        this.registerCustomInjector();
        Assertions.assertTrue((boolean)this.createModel().hasResourceResolver());
    }

    private void registerServices() {
        this.context.registerService(BindingsValuesProvidersByContext.class, (Object)this.bindingsValuesProvidersByContext);
        this.context.registerService(AdapterManager.class, (Object)this.adapterManager);
        this.factory = (ModelAdapterFactory)this.context.registerInjectActivateService((Object)new ModelAdapterFactory());
    }

    private void registerCustomInjector() {
        this.context.registerInjectActivateService((Object)new SlingObjectInjector(), (Map)new ServicePropertiesMap(0L, 0));
    }

    private void registerModel() {
        ModelAdapterFactoryUtil.addModelsForPackage(this.context.bundleContext(), TestModel.class);
    }

    private TestModel createModel() {
        return (TestModel)this.factory.createModel((Object)this.request, TestModel.class);
    }

    @Model(adaptables={SlingJakartaHttpServletRequest.class})
    public static class TestModel {
        @SlingObject(injectionStrategy=InjectionStrategy.OPTIONAL)
        private ResourceResolver resourceResolver;

        public boolean hasResourceResolver() {
            return this.resourceResolver != null;
        }
    }
}

