/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.upgrade;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.syncope.core.persistence.jpa.upgrade.WiserSchemaTool;
import org.springframework.jdbc.core.JdbcTemplate;

public class GenerateUpgradeSQL {
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    private static final String INIT_SQL_STATEMENTS = "INSERT INTO InboundPolicy SELECT * FROM PullPolicy;\nUPDATE ExternalResource SET inboundPolicy_id=pullPolicy_id;\nALTER TABLE ExternalResource DROP COLUMN pullPolicy_id;\n\nINSERT INTO InboundCorrelationRuleEntity(id, inboundPolicy_id, anyType_id, implementation_id)\nSELECT id, pullPolicy_id, anyType_id, implementation_id FROM PullCorrelationRuleEntity;\n\nDROP TABLE PullCorrelationRuleEntity;\nDROP TABLE PullPolicy;\n";
    private static final String FINAL_SQL_STATEMENTS = "DROP TABLE IF EXISTS qrtz_blob_triggers CASCADE;\nDROP TABLE IF EXISTS qrtz_calendars CASCADE;\nDROP TABLE IF EXISTS qrtz_cron_triggers CASCADE;\nDROP TABLE IF EXISTS qrtz_fired_triggers CASCADE;\nDROP TABLE IF EXISTS qrtz_job_details CASCADE;\nDROP TABLE IF EXISTS qrtz_locks CASCADE;\nDROP TABLE IF EXISTS qrtz_paused_trigger_grps CASCADE;\nDROP TABLE IF EXISTS qrtz_scheduler_state CASCADE;\nDROP TABLE IF EXISTS qrtz_simple_triggers CASCADE;\nDROP TABLE IF EXISTS qrtz_simprop_triggers CASCADE;\nDROP TABLE IF EXISTS qrtz_triggers CASCADE;\n";
    private final JDBCConfiguration jdbcConf;
    private final JdbcTemplate jdbcTemplate;

    public GenerateUpgradeSQL(JDBCConfiguration jdbcConf) {
        this.jdbcConf = jdbcConf;
        this.jdbcTemplate = new JdbcTemplate(jdbcConf.getDataSource2(null));
    }

    private String connInstances() throws JsonProcessingException {
        StringBuilder result = new StringBuilder();
        List poolConfs = this.jdbcTemplate.queryForList("SELECT id, maxIdle, maxObjects, maxWait, minEvictableIdleTimeMillis, minIdle FROM ConnInstance WHERE maxidle IS NOT NULL OR maxobjects IS NOT NULL OR maxWait IS NOT NULL OR minEvictableIdleTimeMillis IS NOT NULL OR minIdle IS NOT NULL");
        for (Map poolConf : poolConfs) {
            ObjectNode cpc = MAPPER.createObjectNode();
            Optional.ofNullable(poolConf.get("maxIdle")).ifPresent(v -> cpc.put("maxIdle", (Integer)v));
            Optional.ofNullable(poolConf.get("maxObjects")).ifPresent(v -> cpc.put("maxObjects", (Integer)v));
            Optional.ofNullable(poolConf.get("maxWait")).ifPresent(v -> cpc.put("maxWait", (Long)v));
            Optional.ofNullable(poolConf.get("minEvictableIdleTimeMillis")).ifPresent(v -> cpc.put("minEvictableIdleTimeMillis", (Long)v));
            Optional.ofNullable(poolConf.get("minIdle")).ifPresent(v -> cpc.put("minIdle", (Integer)v));
            result.append(String.format("UPDATE ConnInstance SET poolConf='%s' WHERE id='%s';\n", MAPPER.writeValueAsString((Object)cpc), poolConf.get("id").toString()));
        }
        result.append("ALTER TABLE ConnInstance DROP COLUMN maxidle;\n");
        result.append("ALTER TABLE ConnInstance DROP COLUMN maxobjects;\n");
        result.append("ALTER TABLE ConnInstance DROP COLUMN maxwait;\n");
        result.append("ALTER TABLE ConnInstance DROP COLUMN minevictableidletimemillis;\n");
        result.append("ALTER TABLE ConnInstance DROP COLUMN minidle;\n");
        return result.toString();
    }

    private String resources() throws JsonProcessingException {
        StringBuilder result = new StringBuilder();
        result.append("ALTER TABLE ExternalResource DROP COLUMN overridecapabilities;\n");
        List resources = this.jdbcTemplate.queryForList("SELECT id, provisions FROM ExternalResource WHERE provisions IS NOT NULL");
        for (Map resource : resources) {
            JsonNode provisions = MAPPER.readTree(resource.get("provisions").toString());
            for (JsonNode provision : provisions) {
                if (provision.has("virSchemas")) {
                    ((ObjectNode)provision).remove("virSchemas");
                }
                if (!provision.has("mapping") || !provision.get("mapping").has("linkingItems")) continue;
                ((ObjectNode)provision.get("mapping")).remove("linkingItems");
            }
            result.append(String.format("UPDATE ExternalResource SET provisions='%s' WHERE id='%s';\n", MAPPER.writeValueAsString((Object)provisions).replace("'", "''"), resource.get("id").toString()));
        }
        List accountPolicyResources = this.jdbcTemplate.queryForList("SELECT accountpolicy_id, resource_id FROM AccountPolicy_ExternalResource");
        accountPolicyResources.forEach(acp -> result.append(String.format("UPDATE ExternalResource SET accountPolicy_id='%s' WHERE id='%s';\n", acp.get("accountpolicy_id").toString(), acp.get("resource_id").toString())));
        result.append("DROP TABLE AccountPolicy_ExternalResource;\n");
        return result.toString();
    }

    private String plainSchemas() throws JsonProcessingException {
        StringBuilder result = new StringBuilder();
        List enumerations = this.jdbcTemplate.queryForList("SELECT id, enumerationKeys, enumerationValues FROM PlainSchema WHERE enumerationValues IS NOT NULL");
        for (Map enumeration : enumerations) {
            String[] keys = enumeration.get("enumerationValues").toString().split(";");
            String[] values = Optional.ofNullable(enumeration.get("enumerationKeys")).map(v -> v.toString().split(";")).orElse(keys);
            HashMap<String, String> enumValues = new HashMap<String, String>();
            for (int i = 0; i < keys.length; ++i) {
                enumValues.put(keys[i], values.length > i ? values[i] : keys[i]);
            }
            result.append(String.format("UPDATE PlainSchema SET enumValues='%s' WHERE id='%s';\n", MAPPER.writeValueAsString(enumValues), enumeration.get("id").toString()));
        }
        result.append("ALTER TABLE PlainSchema DROP COLUMN enumerationKeys;\n");
        result.append("ALTER TABLE PlainSchema DROP COLUMN enumerationValues;\n");
        return result.toString();
    }

    private String roles() throws JsonProcessingException {
        StringBuilder result = new StringBuilder();
        List dynMembershipConds = this.jdbcTemplate.queryForList("SELECT role_id AS id, fiql FROM DynRoleMembership");
        dynMembershipConds.forEach(cond -> result.append(String.format("UPDATE SyncopeRole SET dynMembershipCond='%s' WHERE id='%s';\n", cond.get("fiql").toString(), cond.get("id").toString())));
        result.append("DROP TABLE DynRoleMembership;\n");
        List roles = this.jdbcTemplate.queryForList("SELECT id, anyLayout from SyncopeRole WHERE anyLayout IS NOT NULL");
        for (Map role : roles) {
            JsonNode anyLayout = MAPPER.readTree(role.get("anyLayout").toString());
            for (JsonNode child : anyLayout) {
                if (!child.isObject()) continue;
                if (child.has("virAttrs")) {
                    ((ObjectNode)child).remove("virAttrs");
                }
                if (!child.has("whichVirAttrs")) continue;
                ((ObjectNode)child).remove("whichVirAttrs");
            }
            result.append(String.format("UPDATE SyncopeRole SET anyLayout='%s' WHERE id='%s';\n", MAPPER.writeValueAsString((Object)anyLayout).replace("'", "''"), role.get("id").toString()));
        }
        return result.toString();
    }

    private String relationshipTypes() {
        StringBuilder result = new StringBuilder();
        List relationshipTypes = this.jdbcTemplate.queryForList("SELECT id FROM RelationshipType");
        this.jdbcTemplate.setMaxRows(1);
        relationshipTypes.forEach(relationshipType -> {
            List anyObjects = this.jdbcTemplate.queryForList("SELECT anyobject_id FROM URelationship WHERE type_id=?", new Object[]{relationshipType.get("id")});
            if (anyObjects.isEmpty()) {
                anyObjects = this.jdbcTemplate.queryForList("SELECT left_anyobject_id, right_anyobject_id FROM ARelationship WHERE type_id=?", new Object[]{relationshipType.get("id")});
                if (!anyObjects.isEmpty()) {
                    String leftEndAnyType = (String)this.jdbcTemplate.queryForObject("SELECT type_id from AnyObject WHERE id=?", String.class, new Object[]{((Map)anyObjects.getFirst()).get("left_anyobject_id")});
                    String rightEndAnyType = (String)this.jdbcTemplate.queryForObject("SELECT type_id from AnyObject WHERE id=?", String.class, new Object[]{((Map)anyObjects.getFirst()).get("right_anyobject_id")});
                    result.append("UPDATE RelationshipType ").append("SET leftEndAnyType_id='").append(leftEndAnyType).append("', ").append("rightEndAnyType_id='").append(rightEndAnyType).append("' ").append("WHERE id='").append(relationshipType.get("id")).append("';\n");
                }
            } else {
                String rightEndAnyType = (String)this.jdbcTemplate.queryForObject("SELECT type_id from AnyObject WHERE id=?", String.class, new Object[]{((Map)anyObjects.getFirst()).get("anyobject_id")});
                result.append("UPDATE RelationshipType ").append("SET leftEndAnyType_id='USER', ").append("rightEndAnyType_id='").append(rightEndAnyType).append("' ").append("WHERE id='").append(relationshipType.get("id")).append("';\n");
            }
        });
        this.jdbcTemplate.setMaxRows(-1);
        result.append("UPDATE RelationshipType ").append("SET leftEndAnyType_id='USER', rightEndAnyType_id='USER' ").append("WHERE leftEndAnyType_id IS NULL AND rightEndAnyType_id IS NULL;\n");
        return result.toString();
    }

    private String implementations() {
        StringBuilder result = new StringBuilder();
        result.append("UPDATE Implementation ").append("SET type='INBOUND_ACTIONS' WHERE type='PULL_ACTIONS';\n");
        result.append("UPDATE Implementation ").append("SET type='INBOUND_CORRELATION_RULE' WHERE type='PULL_CORRELATION_RULE';\n");
        List implementations = this.jdbcTemplate.queryForList("SELECT id, body from Implementation WHERE body LIKE 'org.apache.syncope.core.persistence.jpa.attrvalue.validation.%'");
        implementations.forEach(implementation -> result.append(String.format("UPDATE Implementation SET body='%s' WHERE id='%s';\n", implementation.get("body").toString().replace("org.apache.syncope.core.persistence.jpa.attrvalue.validation.", "org.apache.syncope.core.persistence.common.attrvalue."), implementation.get("id").toString())));
        return result.toString();
    }

    private String anyTemplates() throws JsonProcessingException {
        JsonNode t;
        StringBuilder result = new StringBuilder();
        List templates = this.jdbcTemplate.queryForList("SELECT id, template from AnyTemplateRealm");
        for (Map template : templates) {
            t = MAPPER.readTree(template.get("template").toString());
            if (!t.has("virAttrs")) continue;
            ((ObjectNode)t).remove("virAttrs");
            result.append(String.format("UPDATE AnyTemplateRealm SET template='%s' WHERE id='%s';\n", MAPPER.writeValueAsString((Object)t).replace("'", "''"), template.get("id").toString()));
        }
        templates = this.jdbcTemplate.queryForList("SELECT id, template from AnyTemplatePullTask");
        for (Map template : templates) {
            t = MAPPER.readTree(template.get("template").toString());
            if (!t.has("virAttrs")) continue;
            ((ObjectNode)t).remove("virAttrs");
            result.append(String.format("UPDATE AnyTemplatePullTask SET template='%s' WHERE id='%s';\n", MAPPER.writeValueAsString((Object)t).replace("'", "''"), template.get("id").toString()));
        }
        return result.toString();
    }

    private String audit() {
        StringBuilder result = new StringBuilder();
        List auditConf = this.jdbcTemplate.queryForList("SELECT id from AuditConf");
        auditConf.forEach(conf -> result.append(String.format("UPDATE AuditConf SET id='%s' WHERE id='%s';\n", conf.get("id").toString().replace("syncope.audit.", ""), conf.get("id").toString())));
        return result.toString();
    }

    public void run(Writer out) throws IOException, SQLException {
        WiserSchemaTool schemaTool = new WiserSchemaTool(this.jdbcConf, "add");
        schemaTool.setSchemaGroup(this.jdbcConf.getSchemaFactoryInstance().readSchema());
        schemaTool.setWriter(out);
        try (Writer writer = out;){
            schemaTool.run();
            out.append('\n').append(INIT_SQL_STATEMENTS).append('\n');
            out.append(this.connInstances()).append('\n');
            out.append(this.resources()).append('\n');
            out.append(this.plainSchemas()).append('\n');
            out.append(this.roles()).append('\n');
            out.append(this.relationshipTypes()).append('\n');
            out.append(this.implementations()).append('\n');
            out.append(this.anyTemplates()).append('\n');
            out.append(this.audit()).append('\n');
            out.append(FINAL_SQL_STATEMENTS);
        }
    }
}

